/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.kie.server.controller.websocket.common.handlers.KieServerMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketSessionManager.class);
    private ConcurrentMap<String, Session> availableSessionsById = new ConcurrentHashMap<String, Session>();
    private ConcurrentMap<String, List<Session>> availableSessionsByUrl = new ConcurrentHashMap<String, List<Session>>();
    private ConcurrentMap<String, String> sessionToUrl = new ConcurrentHashMap<String, String>();
    private ConcurrentMap<String, KieServerMessageHandler> handlersPerSession = new ConcurrentHashMap<String, KieServerMessageHandler>();
    private static WebsocketSessionManager INSTANCE = new WebsocketSessionManager();

    public static WebsocketSessionManager getInstance() {
        return INSTANCE;
    }

    public void addSession(Session session) {
        this.availableSessionsById.put(session.getId(), session);
        this.handlersPerSession.put(session.getId(), new KieServerMessageHandler(session));
        logger.debug("Session '" + session.getId() + "' added to websocket manager");
    }

    public void addSession(String url, Session session) {
        ArrayList<Session> newSessions = new ArrayList<Session>();
        ArrayList<Session> sessions = this.availableSessionsByUrl.putIfAbsent(url, newSessions);
        if (sessions == null) {
            sessions = newSessions;
        }
        sessions.add(session);
        this.sessionToUrl.put(session.getId(), url);
        logger.debug("Session '" + session.getId() + "' associated with url: " + url);
    }

    public String removeSession(Session session) {
        this.availableSessionsById.remove(session.getId());
        String url = (String)this.sessionToUrl.remove(session.getId());
        List sessions = (List)this.availableSessionsByUrl.get(url);
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            Session s = (Session)it.next();
            if (!s.getId().equals(session.getId())) continue;
            it.remove();
            break;
        }
        this.handlersPerSession.remove(session.getId());
        logger.debug("Session '" + session.getId() + "' removed to websocket manager");
        if (((List)this.availableSessionsByUrl.get(url)).isEmpty()) {
            return url;
        }
        return null;
    }

    public List<Session> getByUrl(String url) {
        List sessions = (List)this.availableSessionsByUrl.get(url);
        if (sessions == null) {
            return Collections.emptyList();
        }
        return sessions.stream().filter(s -> s.isOpen()).collect(Collectors.toList());
    }

    public KieServerMessageHandler getHandler(String sessionId) {
        return (KieServerMessageHandler)this.handlersPerSession.get(sessionId);
    }

    public void close() {
        this.availableSessionsById.values().forEach(session -> {
            if (session.isOpen()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Server is going down"));
                }
                catch (Exception e) {
                    logger.warn("Unexpected error while shutting down websocket session", (Throwable)e);
                }
            }
        });
    }
}

