/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.websocket.Session;
import org.kie.api.command.Command;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetReleaseIdCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.GetServerStateCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.jms.ResponseHandler;
import org.kie.server.controller.websocket.WebsocketSessionManager;
import org.kie.server.controller.websocket.WebsocketUtils;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.controller.websocket.common.handlers.WebsocketServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketKieServerClient
implements KieServicesClient {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketKieServerClient.class);
    private WebsocketSessionManager manager = WebsocketSessionManager.getInstance();
    private String url;

    public WebsocketKieServerClient(String url) {
        this.url = url;
    }

    public <T> T getServicesClient(Class<T> serviceClient) {
        if (QueryServicesClient.class.isAssignableFrom(serviceClient)) {
            return (T)new QueryServicesClient(){

                public void unregisterQuery(String queryName) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public void setResponseHandler(ResponseHandler responseHandler) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public void replaceQuery(QueryDefinition queryDefinition) {
                    CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "replaceQuery", WebsocketUtils.marshal(MarshallingFormat.JSON.toString(), queryDefinition), MarshallingFormat.JSON.toString(), new Object[]{queryDefinition.getName()})));
                    WebsocketKieServerClient.this.sendCommandToAllSessions(script, new WebsocketServiceResponse(true, message -> {
                        WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
                        return null;
                    })).getResponses();
                }

                public void registerQuery(QueryDefinition queryDefinition) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public <T> List<T> query(String queryName, String mapper, String builder, Map<String, Object> parameters, Integer page, Integer pageSize, Class<T> resultType) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public <T> List<T> query(String queryName, String mapper, QueryFilterSpec filterSpec, Integer page, Integer pageSize, Class<T> resultType) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public <T> List<T> query(String queryName, String mapper, String orderBy, Integer page, Integer pageSize, Class<T> resultType) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public <T> List<T> query(String queryName, String mapper, Integer page, Integer pageSize, Class<T> resultType) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public QueryDefinition getQuery(String queryName) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<QueryDefinition> getQueries(Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<VariableInstance> findVariablesCurrentState(Long processInstanceId) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<VariableInstance> findVariableHistory(Long processInstanceId, String variableName, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcessesById(String processId) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public ProcessInstance findProcessInstanceById(Long processInstanceId, boolean withVars) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public ProcessInstance findProcessInstanceById(Long processInstanceId) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public ProcessInstance findProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public ProcessDefinition findProcessByContainerIdProcessId(String containerId, String processId) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<NodeInstance> findNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public NodeInstance findNodeInstanceByWorkItemId(Long processInstanceId, Long workItemId) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<NodeInstance> findCompletedNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }

                public List<NodeInstance> findActiveNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
                    throw new UnsupportedOperationException("Not supported for websocket implementation");
                }
            };
        }
        throw new UnsupportedOperationException("Not supported for websocket implementation");
    }

    protected ServiceResponsesList sendCommand(CommandScript script, WebsocketServiceResponse response) {
        logger.debug("About to send command {} to kie server located at {}", (Object)script, (Object)this.url);
        List<Session> sessions = this.manager.getByUrl(this.url);
        Session session = sessions.get(0);
        logger.debug("Websocket session ({}) is open {}", (Object)session.getId(), (Object)session.isOpen());
        String content = WebsocketUtils.marshal(MarshallingFormat.JSON.getType(), script);
        logger.debug("Content to be sent over websocket '{}'", (Object)content);
        try {
            this.manager.getHandler(session.getId()).addHandler((InternalMessageHandler)response);
            session.getBasicRemote().sendText(content);
            logger.debug("Message successfully sent to kie server");
            return new ServiceResponsesList(Arrays.asList(response));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ServiceResponsesList sendCommandToAllSessions(CommandScript script, WebsocketServiceResponse response) {
        logger.debug("About to send command {} to kie server located at {}", (Object)script, (Object)this.url);
        List<Session> sessions = this.manager.getByUrl(this.url);
        ArrayList<WebsocketServiceResponse> responses = new ArrayList<WebsocketServiceResponse>();
        ServiceResponsesList result = new ServiceResponsesList(responses);
        for (Session session : sessions) {
            logger.debug("Websocket session ({}) is open {}", (Object)session.getId(), (Object)session.isOpen());
            String content = WebsocketUtils.marshal(MarshallingFormat.JSON.getType(), script);
            logger.debug("Content to be sent over websocket '{}'", (Object)content);
            try {
                this.manager.getHandler(session.getId()).addHandler((InternalMessageHandler)response);
                session.getBasicRemote().sendText(content);
                logger.debug("Message successfully sent to kie server");
                responses.add(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public ServiceResponse<KieServerInfo> getServerInfo() {
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerInfoCommand()));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        return this.listContainers(KieContainerResourceFilter.ACCEPT_ALL);
    }

    public ServiceResponse<KieContainerResourceList> listContainers(KieContainerResourceFilter containerFilter) {
        CommandScript script = new CommandScript(Collections.singletonList(new ListContainersCommand(containerFilter)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) {
        CommandScript script = new CommandScript(Collections.singletonList(new CreateContainerCommand(resource)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        CommandScript script = new CommandScript(Collections.singletonList(new GetContainerInfoCommand(id)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<Void> disposeContainer(String id) {
        CommandScript script = new CommandScript(Collections.singletonList(new DisposeContainerCommand(id)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponsesList executeScript(CommandScript script) {
        throw new UnsupportedOperationException("Not supported for websocket implementation");
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        CommandScript script = new CommandScript(Collections.singletonList(new GetScannerInfoCommand(id)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateScannerCommand(id, resource)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<ReleaseId> getReleaseId(String containerId) {
        CommandScript script = new CommandScript(Collections.singletonList(new GetReleaseIdCommand(containerId)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateReleaseIdCommand(id, releaseId)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieServerStateInfo> getServerState() {
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerStateCommand()));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebsocketServiceResponse(true, message -> {
            ServiceResponsesList list = WebsocketUtils.unmarshal(message, MarshallingFormat.JSON.getType(), ServiceResponsesList.class);
            return (ServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<String> executeCommands(String id, String payload) {
        throw new UnsupportedOperationException("Not supported for websocket implementation");
    }

    public ServiceResponse<String> executeCommands(String id, Command<?> cmd) {
        throw new UnsupportedOperationException("Not supported for websocket implementation");
    }

    public void setClassLoader(ClassLoader classLoader) {
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public String getConversationId() {
        return null;
    }

    public void completeConversation() {
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
    }
}

