/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import java.util.ArrayList;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.Session;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.KieServerControllerEvent;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.notification.KieServerControllerNotification;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.websocket.notification.WebSocketNotificationService;
import org.kie.server.controller.websocket.notification.WebSocketNotificationSessionManager;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketNotificationServiceTest {
    @Mock
    Session session;
    @Mock
    RemoteEndpoint.Async async;
    @InjectMocks
    WebSocketNotificationService notificationService;

    @Before
    public void setUp() {
        Mockito.when((Object)this.session.getId()).thenReturn((Object)"id");
        Mockito.when((Object)this.session.getAsyncRemote()).thenReturn((Object)this.async);
        WebSocketNotificationSessionManager.getInstance().addSession(this.session);
    }

    @Test
    public void testServerInstanceConnected() {
        ServerInstanceConnected event = new ServerInstanceConnected(new ServerInstance());
        this.notificationService.notify(event);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }

    @Test
    public void testServerInstanceDisconnected() {
        ServerInstanceDisconnected event = new ServerInstanceDisconnected("serverId");
        this.notificationService.notify(event);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }

    @Test
    public void testServerInstanceDeleted() {
        ServerInstanceDeleted event = new ServerInstanceDeleted("serverId");
        this.notificationService.notify(event);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }

    @Test
    public void testServerInstanceUpdated() {
        ServerInstanceUpdated event = new ServerInstanceUpdated(new ServerInstance());
        this.notificationService.notify(event);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }

    @Test
    public void testServerTemplateUpdated() {
        ServerTemplateUpdated event = new ServerTemplateUpdated(new ServerTemplate());
        this.notificationService.notify(event);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }

    @Test
    public void testServerTemplateDeleted() {
        ServerTemplateDeleted event = new ServerTemplateDeleted("serverTemplateId");
        this.notificationService.notify(event);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }

    @Test
    public void testContainerSpecUpdated() {
        ServerTemplate serverTemplate = new ServerTemplate();
        ContainerSpec containerSpec = new ContainerSpec();
        ArrayList containers = new ArrayList();
        ContainerSpecUpdated event = new ContainerSpecUpdated(serverTemplate, containerSpec, containers);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
        ((RemoteEndpoint.Async)Mockito.verify((Object)this.async)).sendObject(Mockito.eq((Object)new KieServerControllerNotification((KieServerControllerEvent)event)), (SendHandler)Matchers.any());
    }
}

