/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketNotificationSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketNotificationSessionManager.class);
    private static final WebSocketNotificationSessionManager INSTANCE = new WebSocketNotificationSessionManager();
    private final ConcurrentMap<String, Session> availableSessionsById = new ConcurrentHashMap<String, Session>();

    public static WebSocketNotificationSessionManager getInstance() {
        return INSTANCE;
    }

    public void addSession(Session session) {
        this.availableSessionsById.put(session.getId(), session);
        LOGGER.debug("Session '" + session.getId() + "' added to Web Socket Notification manager");
    }

    public void removeSession(Session session) {
        this.availableSessionsById.remove(session.getId());
        LOGGER.debug("Session '" + session.getId() + "' removed from Web Socket Notification manager");
    }

    public Collection<Session> getSessions() {
        return this.availableSessionsById.values();
    }
}

