/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.websocket.Session;
import org.kie.api.command.Command;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetReleaseIdCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.GetServerStateCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessInstanceQueryFilterSpec;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.TaskQueryFilterSpec;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.jms.ResponseHandler;
import org.kie.server.controller.websocket.WebSocketSessionManager;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.controller.websocket.common.handlers.WebSocketServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketKieServerClient
implements KieServicesClient {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketKieServerClient.class);
    private WebSocketSessionManager manager = WebSocketSessionManager.getInstance();
    private String url;
    private KieServerInfo serverInfo;

    public WebSocketKieServerClient(String url) {
        this.url = url;
        this.serverInfo = this.manager.getServerInfoByUrl(url);
    }

    private static <T> T throwUnsupportedException() {
        throw new UnsupportedOperationException("Not supported for Web Socket implementation");
    }

    public <T> T getServicesClient(Class<T> serviceClient) {
        if (QueryServicesClient.class.isAssignableFrom(serviceClient)) {
            if (!this.serverInfo.getCapabilities().contains("BPM")) {
                throw new KieServicesException("Server that this client is connected to has no capabilities to handle " + serviceClient.getSimpleName());
            }
            return (T)new QueryServicesClient(){

                public void unregisterQuery(String queryName) {
                    WebSocketKieServerClient.throwUnsupportedException();
                }

                public void setResponseHandler(ResponseHandler responseHandler) {
                    WebSocketKieServerClient.throwUnsupportedException();
                }

                public void replaceQuery(QueryDefinition queryDefinition) {
                    CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "replaceQuery", WebSocketUtils.marshal((Object)queryDefinition), MarshallingFormat.JSON.toString(), new Object[]{queryDefinition.getName()})));
                    WebSocketKieServerClient.this.sendCommandToAllSessions(script, new WebSocketServiceResponse(true, message -> {
                        WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
                        return null;
                    })).getResponses();
                }

                public void registerQuery(QueryDefinition queryDefinition) {
                    WebSocketKieServerClient.throwUnsupportedException();
                }

                public <T> List<T> query(String queryName, String mapper, String builder, Map<String, Object> parameters, Integer page, Integer pageSize, Class<T> resultType) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public <T> List<T> query(String queryName, String mapper, QueryFilterSpec filterSpec, Integer page, Integer pageSize, Class<T> resultType) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public <T> List<T> query(String queryName, String mapper, String orderBy, Integer page, Integer pageSize, Class<T> resultType) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public <T> List<T> query(String queryName, String mapper, Integer page, Integer pageSize, Class<T> resultType) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public <T> List<T> query(String containerId, String queryName, String mapper, String builder, Map<String, Object> parameters, Integer page, Integer pageSize, Class<T> resultType) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public QueryDefinition getQuery(String queryName) {
                    return (QueryDefinition)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<QueryDefinition> getQueries(Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<VariableInstance> findVariablesCurrentState(Long processInstanceId) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<VariableInstance> findVariableHistory(Long processInstanceId, String variableName, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcessesById(String processId) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize, String sort, boolean sortOrder) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public ProcessInstance findProcessInstanceById(Long processInstanceId, boolean withVars) {
                    return (ProcessInstance)WebSocketKieServerClient.throwUnsupportedException();
                }

                public ProcessInstance findProcessInstanceById(Long processInstanceId) {
                    return (ProcessInstance)WebSocketKieServerClient.throwUnsupportedException();
                }

                public ProcessInstance findProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
                    return (ProcessInstance)WebSocketKieServerClient.throwUnsupportedException();
                }

                public ProcessDefinition findProcessByContainerIdProcessId(String containerId, String processId) {
                    return (ProcessDefinition)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<NodeInstance> findNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public NodeInstance findNodeInstanceByWorkItemId(Long processInstanceId, Long workItemId) {
                    return (NodeInstance)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<NodeInstance> findCompletedNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<NodeInstance> findActiveNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<ProcessInstance> findProcessInstancesWithFilters(String queryName, ProcessInstanceQueryFilterSpec filterSpec, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }

                public List<TaskInstance> findHumanTasksWithFilters(String queryName, TaskQueryFilterSpec filterSpec, Integer page, Integer pageSize) {
                    return (List)WebSocketKieServerClient.throwUnsupportedException();
                }
            };
        }
        return WebSocketKieServerClient.throwUnsupportedException();
    }

    protected ServiceResponsesList sendCommand(CommandScript script, WebSocketServiceResponse response) {
        logger.debug("About to send command {} to kie server located at {}", (Object)script, (Object)this.url);
        List<Session> sessions = this.manager.getByUrl(this.url);
        Session session = sessions.get(0);
        logger.debug("Web Socket session ({}) is open {}", (Object)session.getId(), (Object)session.isOpen());
        String content = WebSocketUtils.marshal((Object)script);
        logger.debug("Content to be sent over Web Socket '{}'", (Object)content);
        try {
            this.manager.getHandler(session.getId()).addHandler((InternalMessageHandler)response);
            session.getBasicRemote().sendText(content);
            logger.debug("Message successfully sent to kie server");
            return new ServiceResponsesList(Arrays.asList(response));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ServiceResponsesList sendCommandToAllSessions(CommandScript script, WebSocketServiceResponse response) {
        logger.debug("About to send command {} to kie server located at {}", (Object)script, (Object)this.url);
        List<Session> sessions = this.manager.getByUrl(this.url);
        ArrayList<WebSocketServiceResponse> responses = new ArrayList<WebSocketServiceResponse>();
        ServiceResponsesList result = new ServiceResponsesList(responses);
        for (Session session : sessions) {
            logger.debug("Web Socket session ({}) is open {}", (Object)session.getId(), (Object)session.isOpen());
            String content = WebSocketUtils.marshal((Object)script);
            logger.debug("Content to be sent over Web Socket '{}'", (Object)content);
            try {
                this.manager.getHandler(session.getId()).addHandler((InternalMessageHandler)response);
                session.getBasicRemote().sendText(content);
                logger.debug("Message successfully sent to kie server");
                responses.add(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public ServiceResponse<KieServerInfo> getServerInfo() {
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerInfoCommand()));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        return this.listContainers(KieContainerResourceFilter.ACCEPT_ALL);
    }

    public ServiceResponse<KieContainerResourceList> listContainers(KieContainerResourceFilter containerFilter) {
        CommandScript script = new CommandScript(Collections.singletonList(new ListContainersCommand(containerFilter)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) {
        CommandScript script = new CommandScript(Collections.singletonList(new CreateContainerCommand(resource)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        CommandScript script = new CommandScript(Collections.singletonList(new GetContainerInfoCommand(id)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<Void> disposeContainer(String id) {
        CommandScript script = new CommandScript(Collections.singletonList(new DisposeContainerCommand(id)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponsesList executeScript(CommandScript script) {
        return (ServiceResponsesList)WebSocketKieServerClient.throwUnsupportedException();
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        CommandScript script = new CommandScript(Collections.singletonList(new GetScannerInfoCommand(id)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateScannerCommand(id, resource)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<ReleaseId> getReleaseId(String containerId) {
        CommandScript script = new CommandScript(Collections.singletonList(new GetReleaseIdCommand(containerId)));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateReleaseIdCommand(id, releaseId)));
        ServiceResponse response = (ServiceResponse)this.sendCommandToAllSessions(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<KieServerStateInfo> getServerState() {
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerStateCommand()));
        ServiceResponse response = (ServiceResponse)this.sendCommand(script, new WebSocketServiceResponse(true, message -> {
            ServiceResponsesList list = (ServiceResponsesList)WebSocketUtils.unmarshal((String)message, ServiceResponsesList.class);
            return (KieServiceResponse)list.getResponses().get(0);
        })).getResponses().get(0);
        return response;
    }

    public ServiceResponse<String> executeCommands(String id, String payload) {
        return (ServiceResponse)WebSocketKieServerClient.throwUnsupportedException();
    }

    public ServiceResponse<String> executeCommands(String id, Command<?> cmd) {
        return (ServiceResponse)WebSocketKieServerClient.throwUnsupportedException();
    }

    public void setClassLoader(ClassLoader classLoader) {
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public String getConversationId() {
        return null;
    }

    public void completeConversation() {
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
    }
}

