/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.internal.runtime.helper.BatchExecutionHelper;
import org.kie.scanner.MavenRepository;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.integrationtests.shared.RestJmsXstreamSharedBaseIntegrationTest;

public class KieServerIntegrationTest
extends RestJmsXstreamSharedBaseIntegrationTest {
    private static ReleaseId releaseId1 = new ReleaseId("foo.bar", "baz", "2.1.0.GA");
    private static ReleaseId releaseId2 = new ReleaseId("foo.bar", "baz", "2.1.1.GA");

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerIntegrationTest.createAndDeployKJar((ReleaseId)releaseId1);
        KieServerIntegrationTest.createAndDeployKJar((ReleaseId)releaseId2);
    }

    @Test
    public void testGetServerInfo() throws Exception {
        ServiceResponse reply = this.client.getServerInfo();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieServerInfo info = (KieServerInfo)reply.getResult();
        Assert.assertEquals((Object)this.getServerVersion(), (Object)info.getVersion());
    }

    private String getServerVersion() {
        return System.getProperty("kie.server.version", KieServerEnvironment.getVersion().toString());
    }

    public void testCallContainer() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        String payload = "<batch-execution lookup=\"defaultKieSession\">\n  <insert out-identifier=\"message\">\n    <org.pkg1.Message>\n      <text>Hello World</text>\n    </org.pkg1.Message>\n  </insert>\n  <fire-all-rules/>\n</batch-execution>";
        ServiceResponse reply = this.client.executeCommands("kie1", payload);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    public void testCallContainerMarshallCommands() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        KieServices ks = KieServices.Factory.get();
        File jar = MavenRepository.getMavenRepository().resolveArtifact((org.kie.api.builder.ReleaseId)releaseId1).getFile();
        URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()});
        Class<?> messageClass = cl.loadClass("org.pkg1.Message");
        Object message = messageClass.newInstance();
        Method setter = messageClass.getMethod("setText", String.class);
        Method getter = messageClass.getMethod("getText", new Class[0]);
        setter.invoke(message, "HelloWorld");
        KieCommands kcmd = ks.getCommands();
        Command insert = kcmd.newInsert(message, "message");
        Command fire = kcmd.newFireAllRules();
        BatchExecutionCommand batch = kcmd.newBatchExecution(Arrays.asList(insert, fire), "defaultKieSession");
        String payload = BatchExecutionHelper.newXStreamMarshaller().toXML((Object)batch);
        ServiceResponse reply = this.client.executeCommands("kie1", payload);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        XStream xs = BatchExecutionHelper.newXStreamMarshaller();
        xs.setClassLoader((ClassLoader)cl);
        ExecutionResults results = (ExecutionResults)xs.fromXML((String)reply.getResult());
        Object value = results.getValue("message");
        Assert.assertEquals((Object)"echo:HelloWorld", (Object)getter.invoke(value, new Object[0]));
    }

    public void testCommandScript() throws Exception {
        KieServices ks = KieServices.Factory.get();
        File jar = MavenRepository.getMavenRepository().resolveArtifact((org.kie.api.builder.ReleaseId)releaseId1).getFile();
        URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()});
        Class<?> messageClass = cl.loadClass("org.pkg1.Message");
        Object message = messageClass.newInstance();
        Method setter = messageClass.getMethod("setText", String.class);
        setter.invoke(message, "HelloWorld");
        KieCommands kcmd = ks.getCommands();
        Command insert = kcmd.newInsert(message, "message");
        Command fire = kcmd.newFireAllRules();
        BatchExecutionCommand batch = kcmd.newBatchExecution(Arrays.asList(insert, fire), "defaultKieSession");
        String payload = BatchExecutionHelper.newXStreamMarshaller().toXML((Object)batch);
        String containerId = "command-script-container";
        CreateContainerCommand create = new CreateContainerCommand(new KieContainerResource(containerId, releaseId1, null));
        CallContainerCommand call = new CallContainerCommand(containerId, payload);
        DisposeContainerCommand dispose = new DisposeContainerCommand(containerId);
        List<KieServerCommand> cmds = Arrays.asList(create, call, dispose);
        CommandScript script = new CommandScript(cmds);
        ServiceResponsesList reply = this.client.executeScript(script);
        for (ServiceResponse r : reply.getResponses()) {
            Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)r.getType());
        }
    }

    public void testCallContainerLookupError() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        String payload = "<batch-execution lookup=\"xyz\">\n  <insert out-identifier=\"message\">\n    <org.pkg1.Message>\n      <text>Hello World</text>\n    </org.pkg1.Message>\n  </insert>\n</batch-execution>";
        ServiceResponse reply = this.client.executeCommands("kie1", payload);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
    }

    @Test
    public void testScanner() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        ServiceResponse si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
    }

    @Test
    public void testScannerScanNow() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        ServiceResponse si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.SCANNING, Long.valueOf(0L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
    }

    @Test
    public void testScannerStatusOnContainerInfo() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieContainerResource kci = (KieContainerResource)reply.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)kci.getScanner().getStatus());
        ServiceResponse si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo("kie1").getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)kci.getScanner().getStatus());
        Assert.assertEquals((long)10000L, (long)kci.getScanner().getPollInterval());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo("kie1").getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)kci.getScanner().getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo("kie1").getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)kci.getScanner().getStatus());
    }
}

