/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestJmsSharedBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    @Parameterized.Parameter(value=1)
    public KieServicesConfiguration configuration;
    protected static KieContainer kieContainer;
    protected Marshaller marshaller;

    @Parameterized.Parameters(name="{index}: {0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesRestConfiguration();
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB, restConfiguration}, {MarshallingFormat.JSON, restConfiguration}, {MarshallingFormat.XSTREAM, restConfiguration}));
        if (TestConfig.getRemotingUrl() != null && !TestConfig.skipJMS()) {
            KieServicesConfiguration jmsConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesJmsConfiguration();
            parameterData.addAll(Arrays.asList({MarshallingFormat.JAXB, jmsConfiguration}, {MarshallingFormat.JSON, jmsConfiguration}, {MarshallingFormat.XSTREAM, jmsConfiguration}));
        }
        return parameterData;
    }

    @Override
    protected KieServicesClient createDefaultClient() {
        if (TestConfig.isLocalServer()) {
            KieServicesConfiguration localServerConfig = KieServicesFactory.newRestConfiguration((String)TestConfig.getHttpUrl(), null, null).setMarshallingFormat(this.marshallingFormat);
            return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)localServerConfig);
        }
        this.configuration.setMarshallingFormat(this.marshallingFormat);
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.configuration);
    }
}

