/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestJmsSharedBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    @Parameterized.Parameter(value=1)
    public KieServicesConfiguration configuration;
    protected Map<String, Class<?>> extraClasses = new ConcurrentHashMap();

    @Parameterized.Parameters(name="{index}: {0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesRestConfiguration();
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB, restConfiguration}, {MarshallingFormat.JSON, restConfiguration}, {MarshallingFormat.XSTREAM, restConfiguration}));
        if (TestConfig.getRemotingUrl() != null && !TestConfig.skipJMS()) {
            KieServicesConfiguration jmsConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesJmsConfiguration();
            parameterData.addAll(Arrays.asList({MarshallingFormat.JAXB, jmsConfiguration}, {MarshallingFormat.JSON, jmsConfiguration}, {MarshallingFormat.XSTREAM, jmsConfiguration}));
        }
        return parameterData;
    }

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        KieServicesClient kieServicesClient = null;
        this.addExtraCustomClasses(this.extraClasses);
        if (TestConfig.isLocalServer()) {
            this.configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null).setMarshallingFormat(this.marshallingFormat);
            this.configuration.addJaxbClasses(new HashSet(this.extraClasses.values()));
            kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.configuration);
        } else {
            this.configuration.setMarshallingFormat(this.marshallingFormat);
            this.configuration.addJaxbClasses(new HashSet(this.extraClasses.values()));
            kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.configuration);
        }
        this.setupClients(kieServicesClient);
        return kieServicesClient;
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    protected void setupClients(KieServicesClient kieServicesClient) {
    }

    protected Object createInstance(String objectClassIdentifier, Object ... constructorParameters) {
        Class[] parameterClasses = new Class[constructorParameters.length];
        for (int i = 0; i < constructorParameters.length; ++i) {
            parameterClasses[i] = constructorParameters[i].getClass();
        }
        try {
            Class<?> clazz = this.extraClasses.get(objectClassIdentifier);
            if (clazz != null) {
                Object object = clazz.getConstructor(parameterClasses).newInstance(constructorParameters);
                return object;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create object due " + e.getMessage(), e);
        }
        throw new RuntimeException("Instantiated class isn't defined in extraClasses set. Please define it first.");
    }
}

