/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestOnlyBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter
    public MarshallingFormat marshallingFormat;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON});
    }

    @Override
    protected KieServicesClient createDefaultClient() {
        KieServicesConfiguration config = TestConfig.isLocalServer() ? KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null) : KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
        config.setMarshallingFormat(this.marshallingFormat);
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
    }

    protected MediaType getMediaType() {
        switch (this.marshallingFormat) {
            case JAXB: {
                return MediaType.APPLICATION_XML_TYPE;
            }
            case JSON: {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            case XSTREAM: {
                return MediaType.APPLICATION_XML_TYPE;
            }
        }
        throw new RuntimeException("Unrecognized marshalling format: " + this.marshallingFormat);
    }
}

