/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.category.Smoke;
import org.kie.server.integrationtests.shared.RestJmsSharedBaseIntegrationTest;

public class KieServerContainerCRUDIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    private static ReleaseId releaseId1 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.0.GA");
    private static ReleaseId releaseId2 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.1.GA");

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerContainerCRUDIntegrationTest.createAndDeployKJar((ReleaseId)releaseId1);
        KieServerContainerCRUDIntegrationTest.createAndDeployKJar((ReleaseId)releaseId2);
    }

    @Test
    @Category(value={Smoke.class})
    public void testCreateContainer() throws Exception {
        ServiceResponse reply = this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    @Test
    public void testCreateContainerNonExistingGAV() throws Exception {
        ServiceResponse reply = this.client.createContainer("bad-gav", new KieContainerResource("bad-gav", new ReleaseId("foo", "bar", "0.0.0")));
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
    }

    @Test
    public void testCreateContainerAfterFailure() throws Exception {
        KieContainerResource resource = new KieContainerResource("kie1", new ReleaseId("non-existing", "non-existing", "0.0.0"));
        ServiceResponse reply = this.client.createContainer(resource.getContainerId(), resource);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
        resource.setReleaseId(releaseId1);
        reply = this.client.createContainer(resource.getContainerId(), resource);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    @Test
    @Category(value={Smoke.class})
    public void testGetContainerInfo() throws Exception {
        this.client.createContainer("container-info", new KieContainerResource("container-info", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("container-info");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieContainerResource info = (KieContainerResource)reply.getResult();
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)info.getStatus());
    }

    @Test
    public void testGetContainerInfoNonExisting() throws Exception {
        ServiceResponse reply = this.client.getContainerInfo("non-existing-container");
        logger.info(reply.getMsg());
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
    }

    @Test
    public void testListContainers() throws Exception {
        this.client.createContainer("list-containers-c1", new KieContainerResource("list-containers-c1", releaseId1));
        this.client.createContainer("list-containers-c2", new KieContainerResource("list-containers-c2", releaseId1));
        ServiceResponse reply = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        List containers = ((KieContainerResourceList)reply.getResult()).getContainers();
        Assert.assertEquals((String)"Number of listed containers!", (long)2L, (long)containers.size());
        this.assertContainsContainer(containers, "list-containers-c1");
        this.assertContainsContainer(containers, "list-containers-c2");
    }

    @Test
    public void testUpdateReleaseIdForExistingContainer() throws Exception {
        this.client.createContainer("update-releaseId", new KieContainerResource("update-releaseId", releaseId1));
        ServiceResponse reply = this.client.updateReleaseId("update-releaseId", releaseId2);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        Assert.assertEquals((Object)releaseId2, (Object)reply.getResult());
        ServiceResponse disposeReply = this.client.disposeContainer("update-releaseId");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)disposeReply.getType());
    }

    @Test
    public void testDisposeContainer() throws Exception {
        this.client.createContainer("dispose-container", new KieContainerResource("dispose-container", releaseId1));
        ServiceResponse reply = this.client.disposeContainer("dispose-container");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        ServiceResponse listReply = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)listReply.getType());
        List containers = ((KieContainerResourceList)listReply.getResult()).getContainers();
        KieServerContainerCRUDIntegrationTest.assertNullOrEmpty((String)"No containers returned!", (Collection)containers);
    }

    @Test
    public void testDisposeNonExistingContainer() throws Exception {
        ServiceResponse reply = this.client.disposeContainer("non-existing-container");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    private void assertContainsContainer(List<KieContainerResource> containers, String expectedContainerId) {
        for (KieContainerResource container : containers) {
            if (!container.getContainerId().equals(expectedContainerId)) continue;
            return;
        }
        Assert.fail((String)("Container list " + containers + " does not contain expected container with id " + expectedContainerId));
    }
}

