/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestConfig.class);
    private static Integer ALLOCATED_PORT;
    private static Integer CONTROLLER_ALLOCATED_PORT;
    private static final StringTestParameter PROVIDED_HTTP_URL;
    private static final StringTestParameter PROVIDED_CONTROLLER_HTTP_URL;
    private static final StringTestParameter USERNAME;
    private static final StringTestParameter PASSWORD;
    private static final StringTestParameter INITIAL_CONTEXT_FACTORY;
    private static final StringTestParameter CONNECTION_FACTORY;
    private static final StringTestParameter REMOTING_URL;
    private static final StringTestParameter REQUEST_QUEUE_JNDI;
    private static final StringTestParameter RESPONSE_QUEUE_JNDI;
    private static final StringTestParameter KJARS_BUILD_SETTINGS_XML;

    public static String getKieServerHttpUrl() {
        String httpUrl = "";
        httpUrl = PROVIDED_HTTP_URL.isParameterConfigured() ? (String)PROVIDED_HTTP_URL.getParameterValue() : TestConfig.getEmbeddedKieServerHttpUrl();
        return httpUrl;
    }

    public static String getEmbeddedKieServerHttpUrl() {
        return "http://localhost:" + TestConfig.getKieServerAllocatedPort() + "/server";
    }

    public static String getControllerHttpUrl() {
        String httpUrl = "";
        httpUrl = PROVIDED_CONTROLLER_HTTP_URL.isParameterConfigured() ? (String)PROVIDED_CONTROLLER_HTTP_URL.getParameterValue() : "http://localhost:" + TestConfig.getControllerAllocatedPort() + "/controller";
        return httpUrl;
    }

    public static boolean isControllerProvided() {
        return PROVIDED_CONTROLLER_HTTP_URL.isParameterConfigured();
    }

    public static Integer getKieServerAllocatedPort() {
        if (ALLOCATED_PORT == null) {
            try {
                ServerSocket server = new ServerSocket(0);
                ALLOCATED_PORT = server.getLocalPort();
                server.close();
            }
            catch (IOException e) {
                ALLOCATED_PORT = 9789;
            }
            LOGGER.debug("Allocating port {}.", (Object)ALLOCATED_PORT);
        }
        return ALLOCATED_PORT;
    }

    public static Integer getControllerAllocatedPort() {
        if (CONTROLLER_ALLOCATED_PORT == null) {
            try {
                ServerSocket server = new ServerSocket(0);
                CONTROLLER_ALLOCATED_PORT = server.getLocalPort();
                server.close();
            }
            catch (IOException e) {
                CONTROLLER_ALLOCATED_PORT = 9689;
            }
            LOGGER.debug("Allocating port {}.", (Object)CONTROLLER_ALLOCATED_PORT);
        }
        return CONTROLLER_ALLOCATED_PORT;
    }

    public static boolean skipJMS() {
        return TestConfig.class.getResource("/jms.skip") != null;
    }

    public static boolean isLocalServer() {
        boolean isLocalServer = true;
        if (PROVIDED_HTTP_URL.isParameterConfigured() || REMOTING_URL.isParameterConfigured() || PROVIDED_CONTROLLER_HTTP_URL.isParameterConfigured()) {
            isLocalServer = false;
        }
        return isLocalServer;
    }

    public static String getUsername() {
        return (String)USERNAME.getParameterValue();
    }

    public static String getPassword() {
        return (String)PASSWORD.getParameterValue();
    }

    public static String getInitialContextFactory() {
        return (String)INITIAL_CONTEXT_FACTORY.getParameterValue();
    }

    public static String getConnectionFactory() {
        return (String)CONNECTION_FACTORY.getParameterValue();
    }

    public static String getRemotingUrl() {
        return (String)REMOTING_URL.getParameterValue();
    }

    public static String getRequestQueueJndi() {
        return (String)REQUEST_QUEUE_JNDI.getParameterValue();
    }

    public static String getResponseQueueJndi() {
        return (String)RESPONSE_QUEUE_JNDI.getParameterValue();
    }

    public static InitialContext getInitialRemoteContext() {
        InitialContext context = null;
        try {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", TestConfig.getInitialContextFactory());
            env.put("java.naming.provider.url", TestConfig.getRemotingUrl());
            env.put("java.naming.security.principal", TestConfig.getUsername());
            env.put("java.naming.security.credentials", TestConfig.getPassword());
            context = new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to create initial context!", e);
        }
        return context;
    }

    public static String getKjarsBuildSettingsXml() {
        return (String)KJARS_BUILD_SETTINGS_XML.getParameterValue();
    }

    static {
        LOGGER.info("----- Initializing TestConfig -----");
        PROVIDED_HTTP_URL = new StringTestParameter("kie.server.base.http.url");
        PROVIDED_CONTROLLER_HTTP_URL = new StringTestParameter("kie.server.controller.base.http.url");
        USERNAME = new StringTestParameter("username", "yoda");
        PASSWORD = new StringTestParameter("password", "usetheforce123@");
        INITIAL_CONTEXT_FACTORY = new StringTestParameter("kie.server.context.factory", "org.jboss.naming.remote.client.InitialContextFactory");
        CONNECTION_FACTORY = new StringTestParameter("kie.server.connection.factory", "jms/RemoteConnectionFactory");
        REMOTING_URL = new StringTestParameter("kie.server.remoting.url");
        REQUEST_QUEUE_JNDI = new StringTestParameter("kie.server.jndi.request.queue", "jms/queue/KIE.SERVER.REQUEST");
        RESPONSE_QUEUE_JNDI = new StringTestParameter("kie.server.jndi.response.queue", "jms/queue/KIE.SERVER.RESPONSE");
        KJARS_BUILD_SETTINGS_XML = new StringTestParameter("kie.server.testing.kjars.build.settings.xml");
        TreeMap<String, String> params = new TreeMap<String, String>();
        int maxKeyLength = 0;
        for (Field f : TestConfig.class.getDeclaredFields()) {
            if (!TestParameter.class.isAssignableFrom(f.getType())) continue;
            try {
                String paramName = f.getName();
                TestParameter paramValue = (TestParameter)f.get(null);
                maxKeyLength = Math.max(maxKeyLength, paramName.length());
                if (!paramValue.isParameterConfigured()) continue;
                params.put(paramName, paramValue.getParameterValue().toString());
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Cannot read field '{}'.", (Object)f.getName(), (Object)ex);
            }
        }
        for (Map.Entry entry : params.entrySet()) {
            String paramName = (String)entry.getKey();
            String value = (String)entry.getValue();
            LOGGER.info("{} = {}", (Object)String.format("%" + maxKeyLength + "s", paramName), (Object)value);
        }
    }

    private static class StringTestParameter
    extends TestParameter<String> {
        private StringTestParameter(String key) {
            super(key, null);
        }

        private StringTestParameter(String key, String defaultValue) {
            super(key, defaultValue);
        }

        @Override
        protected String convert(String key) {
            String systemPropertyValue = System.getProperty(key);
            if (systemPropertyValue == null || systemPropertyValue.isEmpty()) {
                return null;
            }
            return systemPropertyValue;
        }
    }

    private static abstract class TestParameter<T> {
        private String key;
        private T defaultValue;

        private TestParameter(String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public T getParameterValue() {
            T parameterValue = this.convert(this.key);
            return parameterValue != null ? parameterValue : this.defaultValue;
        }

        public boolean isParameterConfigured() {
            T parameterValue = this.convert(this.key);
            return parameterValue != null;
        }

        protected abstract T convert(String var1);
    }
}

