/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common.rest;

import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.util.GenericType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.category.RESTOnly;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.RestOnlyBaseIntegrationTest;

@Category(value={RESTOnly.class})
public class RestMalformedRequestIntegrationTest
extends RestOnlyBaseIntegrationTest {
    @Test
    public void testCreateContainerNonExistingGAV2() throws Exception {
        KieContainerResource resource = new KieContainerResource("no-gav2-container", new ReleaseId("foo", "bar", "0.0.0"));
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(TestConfig.getKieServerHttpUrl() + "/containers/" + resource.getContainerId());
            response = clientRequest.body(this.getMediaType(), (Object)resource).accept(this.getMediaType()).put((GenericType)new GenericType<ServiceResponse<KieContainerResource>>(){});
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception creating container: " + resource.getContainerId() + " with release-id " + resource.getReleaseId(), (Throwable)e, response);
        }
        finally {
            response.releaseConnection();
        }
    }

    @Test
    public void testCreateContainerEmptyBody() throws Exception {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(TestConfig.getKieServerHttpUrl() + "/containers/empty-body-container");
            response = clientRequest.body(this.getMediaType(), (Object)"").accept(this.getMediaType()).put((GenericType)new GenericType<ServiceResponse<KieContainerResource>>(){});
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception on empty body", (Throwable)e, response);
        }
        finally {
            response.releaseConnection();
        }
    }
}

