/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestOnlyBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter
    public MarshallingFormat marshallingFormat;
    private static HttpClient httpClient;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON});
    }

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        KieServicesConfiguration config = TestConfig.isLocalServer() ? KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null) : KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
        return this.createDefaultClient(config, this.marshallingFormat);
    }

    protected MediaType getMediaType() {
        switch (this.marshallingFormat) {
            case JAXB: {
                return MediaType.APPLICATION_XML_TYPE;
            }
            case JSON: {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            case XSTREAM: {
                return MediaType.APPLICATION_XML_TYPE;
            }
        }
        throw new RuntimeException("Unrecognized marshalling format: " + this.marshallingFormat);
    }

    protected ClientRequest newRequest(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed request URI was specified: '" + uriString + "'!", e);
        }
        if (httpClient == null) {
            RequestConfig requestConfig;
            if (TestConfig.isLocalServer()) {
                requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(1000).setSocketTimeout(1000).build();
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            } else {
                requestConfig = RequestConfig.custom().setConnectionRequestTimeout(2000).setConnectTimeout(2000).setSocketTimeout(2000).build();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(TestConfig.getUsername(), TestConfig.getPassword()));
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            }
        }
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor(httpClient);
        return new ClientRequest(uriString, (ClientExecutor)executor);
    }
}

