/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.kie.api.command.Command;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.JobServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.SolverServicesClient;
import org.kie.server.client.UserTaskServicesClient;

public class KieServerSynchronization {
    private static final long SERVICE_TIMEOUT = 30000L;
    private static final long TIMEOUT_BETWEEN_CALLS = 200L;

    public static void waitForJobToFinish(final JobServicesClient jobServicesClient, final Long jobId) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                RequestInfoInstance result = jobServicesClient.getRequestById(jobId, false, false);
                return STATUS.CANCELLED.toString().equals(result.getStatus()) || STATUS.DONE.toString().equals(result.getStatus()) || STATUS.ERROR.toString().equals(result.getStatus());
            }
        });
    }

    public static void waitForKieServerSynchronization(final KieServicesClient client, final int numberOfExpectedContainers) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ServiceResponse containersList = client.listContainers();
                if (((KieContainerResourceList)containersList.getResult()).getContainers() == null) {
                    if (numberOfExpectedContainers == 0) {
                        return true;
                    }
                } else if (numberOfExpectedContainers == ((KieContainerResourceList)containersList.getResult()).getContainers().size()) {
                    boolean containersInitializing = false;
                    for (KieContainerResource container : ((KieContainerResourceList)containersList.getResult()).getContainers()) {
                        if (!KieContainerStatus.CREATING.equals((Object)container.getStatus()) && !KieContainerStatus.DISPOSING.equals((Object)container.getStatus())) continue;
                        containersInitializing = true;
                    }
                    if (!containersInitializing) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static void waitForProcessInstanceToFinish(final ProcessServicesClient processClient, final String containerId, final long processInstanceId) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ProcessInstance processInstance = processClient.getProcessInstance(containerId, Long.valueOf(processInstanceId));
                return Integer.valueOf(2).equals(processInstance.getState()) || Integer.valueOf(3).equals(processInstance.getState());
            }
        });
    }

    public static void waitForProcessInstanceStart(final QueryServicesClient queryClient, String containerId) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                List processInstances = queryClient.findProcessInstances(Integer.valueOf(0), Integer.valueOf(100));
                return processInstances.size() == 1;
            }
        });
    }

    public static void waitForContainerWithReleaseId(final KieServicesClient client, final ReleaseId releaseId) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ReleaseIdFilter releaseIdFilter = new ReleaseIdFilter(releaseId);
                KieContainerResourceFilter resourceFilter = new KieContainerResourceFilter(releaseIdFilter);
                ServiceResponse containersList = client.listContainers(resourceFilter);
                List containers = ((KieContainerResourceList)containersList.getResult()).getContainers();
                return containers != null && !containers.isEmpty();
            }
        });
    }

    public static void waitForContainerWithScannerStatus(final KieServicesClient client, final KieScannerStatus scannerStatus) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ServiceResponse containersList = client.listContainers();
                List containers = ((KieContainerResourceList)containersList.getResult()).getContainers();
                if (containers != null) {
                    for (KieContainerResource container : containers) {
                        KieScannerResource scanner = container.getScanner();
                        if (scanner == null || !scannerStatus.equals((Object)scanner.getStatus())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static void waitForSolver(final SolverServicesClient client, final String containerId, final String solverId) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ServiceResponse solverListResponse = client.getSolvers(containerId);
                SolverInstanceList solverList = (SolverInstanceList)solverListResponse.getResult();
                for (SolverInstance solver : solverList.getContainers()) {
                    if (!solverId.equals(solver.getSolverId())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static void waitForSolverStatus(final SolverServicesClient client, final String containerId, final String solverId, final SolverInstance.SolverStatus status) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ServiceResponse solverResponse = client.getSolverState(containerId, solverId);
                return status.equals((Object)((SolverInstance)solverResponse.getResult()).getStatus());
            }
        });
    }

    public static void waitForCommandResult(final RuleServicesClient client, final String containerId, final Command command, final String identifier, final Object value) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                ServiceResponse response = client.executeCommandsWithResults(containerId, command);
                ExecutionResults result = (ExecutionResults)response.getResult();
                return value.equals(result.getValue(identifier));
            }
        });
    }

    public static void waitForTaskStatus(final UserTaskServicesClient client, final Long taskId, final String status) throws Exception {
        KieServerSynchronization.waitForCondition(new WaitingCondition(){

            @Override
            public boolean conditionPassed() {
                TaskInstance task = client.findTaskById(taskId);
                return status.equals(task.getStatus());
            }
        });
    }

    private static void waitForCondition(WaitingCondition condition) throws Exception {
        long timeoutTime = Calendar.getInstance().getTimeInMillis() + 30000L;
        while (Calendar.getInstance().getTimeInMillis() < timeoutTime) {
            if (condition.conditionPassed()) {
                return;
            }
            Thread.sleep(200L);
        }
        throw new TimeoutException("Timeout while waiting for condition to be true.");
    }

    private static interface WaitingCondition {
        public boolean conditionPassed();
    }
}

