/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public class KieServerContainerListFilteringIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    private static ReleaseId releaseId1 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.0.GA");
    private static ReleaseId releaseId2 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.1.GA");
    private static ReleaseId releaseId3 = new ReleaseId("org.kie.server.testing", "container-crud-tests2", "2.1.2.GA");
    private static final String CONTAINER_ID_1 = "list-containers-releaseId-c1";
    private static final String CONTAINER_ID_2 = "list-containers-releaseId-c2";
    private static final String CONTAINER_ID_3 = "list-containers-releaseId-c3";
    private static final ReleaseIdFilter VERSION_FILTER_1 = new ReleaseIdFilter.Builder().version("2.1.0.GA").build();
    private static final ReleaseIdFilter VERSION_FILTER_2 = new ReleaseIdFilter.Builder().version("3.0.0.GA").build();
    private static final ReleaseIdFilter ARTIFACT_ID_FILTER = new ReleaseIdFilter.Builder().artifactId("container-crud-tests2").build();
    private static final ReleaseIdFilter GROUP_ID_FILTER = new ReleaseIdFilter.Builder().groupId("org.kie.server.testing").build();
    private static final ReleaseIdFilter ARTIFACT_ID_VERSION_FILTER = new ReleaseIdFilter.Builder().artifactId("container-crud-tests1").version("2.1.1.GA").build();
    private static final ReleaseIdFilter GROUPD_ID_ARTIFACT_ID_FILTER = new ReleaseIdFilter.Builder().groupId("org.kie.server.testing").artifactId("container-crud-tests1").build();
    private static final ReleaseIdFilter RELEASE_ID_FILTER_1 = new ReleaseIdFilter("org.kie.server.testing", "container-crud-tests1", "2.1.0.GA");
    private static final ReleaseIdFilter RELEASE_ID_FILTER_2 = new ReleaseIdFilter("org.kie.server.testing", "container-crud-tests2", "2.1.2.GA");
    private static final KieContainerStatusFilter CREATING_DISPOSING_FILTER = new KieContainerStatusFilter(new KieContainerStatus[]{KieContainerStatus.CREATING, KieContainerStatus.DISPOSING});
    private static final KieContainerStatusFilter STARTED_FILTER = new KieContainerStatusFilter(new KieContainerStatus[]{KieContainerStatus.STARTED});
    @Parameterized.Parameter(value=2)
    public ReleaseIdFilter releaseIdFilter;
    @Parameterized.Parameter(value=3)
    public KieContainerStatusFilter statusFilter;
    @Parameterized.Parameter(value=4)
    public List<String> expectedContainersIds;

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.createAndDeployKJar((ReleaseId)releaseId1);
        KieServerDeployer.createAndDeployKJar((ReleaseId)releaseId2);
    }

    @Before
    public void setupKieServer() throws Exception {
        KieServerContainerListFilteringIntegrationTest.disposeAllContainers();
        this.client.createContainer(CONTAINER_ID_1, new KieContainerResource(CONTAINER_ID_1, releaseId1));
        this.client.createContainer(CONTAINER_ID_2, new KieContainerResource(CONTAINER_ID_2, releaseId2));
        this.client.createContainer(CONTAINER_ID_3, new KieContainerResource(CONTAINER_ID_3, releaseId3));
    }

    @Parameterized.Parameters(name="{index}: {0} {1} {2} {3} {4}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> testData = new ArrayList<Object[]>(Arrays.asList({VERSION_FILTER_1, KieContainerStatusFilter.ACCEPT_ALL, Arrays.asList(CONTAINER_ID_1)}, {VERSION_FILTER_2, CREATING_DISPOSING_FILTER, Arrays.asList(new String[0])}, {ARTIFACT_ID_FILTER, KieContainerStatusFilter.ACCEPT_ALL, Arrays.asList(CONTAINER_ID_3)}, {GROUP_ID_FILTER, KieContainerStatusFilter.ACCEPT_ALL, Arrays.asList(CONTAINER_ID_1, CONTAINER_ID_2, CONTAINER_ID_3)}, {ARTIFACT_ID_VERSION_FILTER, STARTED_FILTER, Arrays.asList(CONTAINER_ID_2)}, {GROUPD_ID_ARTIFACT_ID_FILTER, KieContainerStatusFilter.ACCEPT_ALL, Arrays.asList(CONTAINER_ID_1, CONTAINER_ID_2)}, {RELEASE_ID_FILTER_1, KieContainerStatusFilter.ACCEPT_ALL, Arrays.asList(CONTAINER_ID_1)}, {RELEASE_ID_FILTER_2, STARTED_FILTER, Arrays.asList(new String[0])}, {ReleaseIdFilter.ACCEPT_ALL, STARTED_FILTER, Arrays.asList(CONTAINER_ID_1, CONTAINER_ID_2)}, {ReleaseIdFilter.ACCEPT_ALL, KieContainerStatusFilter.ACCEPT_ALL, Arrays.asList(CONTAINER_ID_1, CONTAINER_ID_2, CONTAINER_ID_3)}));
        return KieServerContainerListFilteringIntegrationTest.createParametersCollection(testData);
    }

    private static Collection<Object[]> createParametersCollection(Collection<Object[]> data) {
        ArrayList<Object[]> toReturn = new ArrayList<Object[]>();
        for (Object[] row : data) {
            for (Object[] settings : RestJmsSharedBaseIntegrationTest.data()) {
                toReturn.add(Stream.of(settings, row).flatMap(Stream::of).toArray(Object[]::new));
            }
        }
        return toReturn;
    }

    @Test
    public void testListContainersWithFiltering() {
        ServiceResponse reply = this.client.listContainers(new KieContainerResourceFilter(this.releaseIdFilter, this.statusFilter));
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        List contianers = ((KieContainerResourceList)reply.getResult()).getContainers();
        if (this.expectedContainersIds.isEmpty()) {
            KieServerAssert.assertNullOrEmpty((String)"Should be return empty list", (Collection)contianers);
        } else {
            Assert.assertNotNull((Object)contianers);
            Assert.assertEquals((long)this.expectedContainersIds.size(), (long)contianers.size());
            this.checkContainersList(contianers);
        }
    }

    private void checkContainersList(List<KieContainerResource> containers) {
        for (KieContainerResource container : containers) {
            Assert.assertTrue((boolean)this.isContainerExpected(container));
            this.checkReleaseIdByFilter(container.getReleaseId());
            this.checkContainerStatusByFilter(container.getStatus());
        }
    }

    private boolean isContainerExpected(KieContainerResource container) {
        return this.expectedContainersIds.contains(container.getContainerId());
    }

    private void checkReleaseIdByFilter(ReleaseId releaseId) {
        String version = this.releaseIdFilter.getVersion();
        String artifactId = this.releaseIdFilter.getArtifactId();
        String groupId = this.releaseIdFilter.getGroupId();
        if (version != null) {
            Assert.assertEquals((Object)version, (Object)releaseId.getVersion());
        }
        if (artifactId != null) {
            Assert.assertEquals((Object)artifactId, (Object)releaseId.getArtifactId());
        }
        if (groupId != null) {
            Assert.assertEquals((Object)groupId, (Object)releaseId.getGroupId());
        }
    }

    private void checkContainerStatusByFilter(KieContainerStatus status) {
        if (this.statusFilter.getAcceptedStatuses().isEmpty()) {
            return;
        }
        for (KieContainerStatus expectedStatus : this.statusFilter.getAcceptedStatuses()) {
            if (!expectedStatus.equals((Object)status)) continue;
            return;
        }
        Assert.fail((String)("Status " + status + " is not in expected list " + this.expectedContainersIds));
    }
}

