/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller.client;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.client.exception.UnexpectedResponseCodeException;
import org.kie.server.integrationtests.shared.filter.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KieServerControllerClient {
    private static Logger logger = LoggerFactory.getLogger(KieServerControllerClient.class);
    private String controllerBaseUrl;
    private static final MarshallingFormat DEFAULT_MARSHALLING_FORMAT = MarshallingFormat.JAXB;
    private MarshallingFormat format;
    private Client httpClient;
    protected Marshaller marshaller;

    public KieServerControllerClient(String controllerBaseUrl, String login, String password, MarshallingFormat format) {
        this.controllerBaseUrl = controllerBaseUrl;
        this.httpClient = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(10L, TimeUnit.SECONDS).build();
        if (login == null) {
            login = TestConfig.getUsername();
            password = TestConfig.getPassword();
        }
        this.httpClient.register((Object)new Authenticator(login, password));
        this.setMarshallingFormat(format);
    }

    public KieServerControllerClient(String controllerBaseUrl, String login, String password) {
        this(controllerBaseUrl, login, password, DEFAULT_MARSHALLING_FORMAT);
    }

    public KieServerInstance getKieServerInstance(String kieServerInstanceId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId, KieServerInstance.class);
    }

    public KieServerInstance createKieServerInstance(KieServerInfo kieServerInfo) {
        return this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInfo.getServerId(), kieServerInfo, KieServerInstance.class);
    }

    public void deleteKieServerInstance(String kieServerInstanceId) {
        this.makeDeleteRequest(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId);
    }

    public KieServerInstanceList listKieServerInstances() {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/servers", KieServerInstanceList.class);
    }

    public KieContainerResource getContainerInfo(String kieServerInstanceId, String containerId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId, KieContainerResource.class);
    }

    public KieContainerResource createContainer(String kieServerInstanceId, String containerId, KieContainerResource container) {
        return this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId, container, KieContainerResource.class);
    }

    public void disposeContainer(String kieServerInstanceId, String containerId) {
        this.makeDeleteRequest(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId);
    }

    public void startContainer(String kieServerInstanceId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId + "/status/started", "", null);
    }

    public void stopContainer(String kieServerInstanceId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId + "/status/stopped", "", null);
    }

    private <T> T makeGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        WebTarget clientRequest = this.httpClient.target(uri);
        Response response = clientRequest.request(new String[]{this.getMediaType(this.format)}).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private void makeDeleteRequest(String uri) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).delete();
            response.close();
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
    }

    private <T> T makePutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            Entity requestEntity = Entity.entity((Object)this.serialize(bodyObject), (String)this.getMediaType(this.format));
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).put(requestEntity);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private <T> T makePostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            Entity requestEntity = Entity.entity((Object)this.serialize(bodyObject), (String)this.getMediaType(this.format));
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).post(requestEntity);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode() || response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(WebTarget request, Response response) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unexpected HTTP response code when requesting URI '");
        stringBuffer.append(this.getClientRequestUri(request));
        stringBuffer.append("'! Response code: ");
        stringBuffer.append(response.getStatus());
        try {
            String responseEntity = (String)response.readEntity(String.class);
            stringBuffer.append(" Response message: ");
            stringBuffer.append(responseEntity);
        }
        catch (IllegalStateException e) {
            response.close();
        }
        logger.debug(stringBuffer.toString());
        return new UnexpectedResponseCodeException(response.getStatus(), stringBuffer.toString());
    }

    private RuntimeException createExceptionForUnexpectedFailure(WebTarget request, Exception e) {
        String summaryMessage = "Unexpected exception when requesting URI '" + this.getClientRequestUri(request) + "'!";
        logger.debug(summaryMessage);
        return new RuntimeException(summaryMessage, e);
    }

    private String getClientRequestUri(WebTarget clientRequest) {
        String uri;
        try {
            uri = clientRequest.getUri().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed client URL was specified!", e);
        }
        return uri;
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.error("Exception thrown while closing resources!", (Throwable)e);
        }
    }

    public MarshallingFormat getMarshallingFormat() {
        return this.format;
    }

    public void setMarshallingFormat(MarshallingFormat format) {
        this.format = format;
        HashSet<Class<KieServerStatus>> controllerClasses = new HashSet<Class<KieServerStatus>>();
        controllerClasses.add(KieServerInstance.class);
        controllerClasses.add(KieServerInstanceList.class);
        controllerClasses.add(KieServerInstanceInfo.class);
        controllerClasses.add(KieServerSetup.class);
        controllerClasses.add(KieServerStatus.class);
        switch (format) {
            case JAXB: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerControllerClient.class.getClassLoader());
                break;
            }
            case JSON: {
                this.marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)format, (ClassLoader)KieServerControllerClient.class.getClassLoader());
                break;
            }
            default: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerControllerClient.class.getClassLoader());
            }
        }
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(Response response, Class<T> type) {
        try {
            if (type == null) {
                T t = null;
                return t;
            }
            String content = (String)response.readEntity(String.class);
            logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
            if (content == null || content.isEmpty()) {
                T t = null;
                return t;
            }
            Object object = this.marshaller.unmarshall(content, type);
            return (T)object;
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while deserializing data received from server!", e);
        }
        finally {
            response.close();
        }
    }
}

