/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestJmsSharedBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    @Parameterized.Parameter(value=1)
    public KieServicesConfiguration configuration;
    protected static KieCommands commandsFactory;
    protected static KieContainer kieContainer;
    protected static final String PERSON_CLASS_NAME = "org.jbpm.data.Person";

    @Parameterized.Parameters(name="{index}: {0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesRestConfiguration();
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB, restConfiguration}, {MarshallingFormat.JSON, restConfiguration}, {MarshallingFormat.XSTREAM, restConfiguration}));
        if (TestConfig.getRemotingUrl() != null && !TestConfig.skipJMS()) {
            KieServicesConfiguration jmsConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesJmsConfiguration();
            parameterData.addAll(Arrays.asList({MarshallingFormat.JAXB, jmsConfiguration}, {MarshallingFormat.JSON, jmsConfiguration}, {MarshallingFormat.XSTREAM, jmsConfiguration}));
        }
        return parameterData;
    }

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        this.addExtraCustomClasses(this.extraClasses);
        if (TestConfig.isLocalServer()) {
            this.configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null);
        }
        return this.createDefaultClient(this.configuration, this.marshallingFormat);
    }

    protected Object createInstance(String objectClassIdentifier, Object ... constructorParameters) {
        Class[] parameterClasses = new Class[constructorParameters.length];
        for (int i = 0; i < constructorParameters.length; ++i) {
            parameterClasses[i] = constructorParameters[i].getClass();
        }
        try {
            Class clazz = (Class)this.extraClasses.get(objectClassIdentifier);
            if (clazz != null) {
                Object object = clazz.getConstructor(parameterClasses).newInstance(constructorParameters);
                return object;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create object due " + e.getMessage(), e);
        }
        throw new RuntimeException("Instantiated class isn't defined in extraClasses set. Please define it first.");
    }

    protected Object createPersonInstance(String name) {
        return this.createInstance(PERSON_CLASS_NAME, name);
    }

    protected void changeUser(String username) throws Exception {
        if (username == null) {
            username = TestConfig.getUsername();
        }
        this.configuration.setUserName(username);
        this.client = this.createDefaultClient();
    }

    protected Object valueOf(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setValue(Object object, String fieldName, Object newValue) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to set value to field %s in object %s due " + e.getMessage(), fieldName, object), e);
        }
    }

    protected static KieServicesConfiguration createKieServicesJmsConfiguration() {
        try {
            InitialContext context = TestConfig.getInitialRemoteContext();
            Queue requestQueue = (Queue)context.lookup(TestConfig.getRequestQueueJndi());
            Queue responseQueue = (Queue)context.lookup(TestConfig.getResponseQueueJndi());
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(TestConfig.getConnectionFactory());
            KieServicesConfiguration jmsConfiguration = KieServicesFactory.newJMSConfiguration((ConnectionFactory)connectionFactory, (Queue)requestQueue, (Queue)responseQueue, (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
            return jmsConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create JMS client configuration!", e);
        }
    }

    protected static KieServicesConfiguration createKieServicesRestConfiguration() {
        return KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }
}

