/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.category.Smoke;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

public class KieServerContainerCRUDIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    private static ReleaseId releaseId1 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.0.GA");
    private static ReleaseId releaseId2 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.1.GA");

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.createAndDeployKJar((ReleaseId)releaseId1);
        KieServerDeployer.createAndDeployKJar((ReleaseId)releaseId2);
    }

    @Before
    public void setupKieServer() throws Exception {
        KieServerContainerCRUDIntegrationTest.disposeAllContainers();
    }

    @Test
    @Category(value={Smoke.class})
    public void testCreateContainer() throws Exception {
        ServiceResponse reply = this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        KieServerAssert.assertSuccess((ServiceResponse)reply);
    }

    @Test
    public void testCreateContainerNonExistingGAV() throws Exception {
        ServiceResponse reply = this.client.createContainer("bad-gav", new KieContainerResource("bad-gav", new ReleaseId("foo", "bar", "0.0.0")));
        KieServerAssert.assertFailure((ServiceResponse)reply);
    }

    @Test
    public void testCreateContainerAfterFailure() throws Exception {
        KieContainerResource resource = new KieContainerResource("kie1", new ReleaseId("non-existing", "non-existing", "0.0.0"));
        ServiceResponse reply = this.client.createContainer(resource.getContainerId(), resource);
        KieServerAssert.assertFailure((ServiceResponse)reply);
        resource.setReleaseId(releaseId1);
        reply = this.client.createContainer(resource.getContainerId(), resource);
        KieServerAssert.assertSuccess((ServiceResponse)reply);
    }

    @Test
    @Category(value={Smoke.class})
    public void testGetContainerInfo() throws Exception {
        this.client.createContainer("container-info", new KieContainerResource("container-info", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("container-info");
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        KieContainerResource info = (KieContainerResource)reply.getResult();
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)info.getStatus());
    }

    @Test
    public void testGetContainerInfoNonExisting() throws Exception {
        ServiceResponse reply = this.client.getContainerInfo("non-existing-container");
        logger.info(reply.getMsg());
        KieServerAssert.assertFailure((ServiceResponse)reply);
    }

    @Test
    public void testListContainers() throws Exception {
        this.client.createContainer("list-containers-c1", new KieContainerResource("list-containers-c1", releaseId1));
        this.client.createContainer("list-containers-c2", new KieContainerResource("list-containers-c2", releaseId1));
        ServiceResponse reply = this.client.listContainers();
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        List containers = ((KieContainerResourceList)reply.getResult()).getContainers();
        Assert.assertEquals((String)"Number of listed containers!", (long)2L, (long)containers.size());
        this.assertContainsContainer(containers, "list-containers-c1");
        this.assertContainsContainer(containers, "list-containers-c2");
    }

    @Test
    public void testUpdateReleaseIdForExistingContainer() throws Exception {
        this.client.createContainer("update-releaseId", new KieContainerResource("update-releaseId", releaseId1));
        ServiceResponse reply = this.client.updateReleaseId("update-releaseId", releaseId2);
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        Assert.assertEquals((Object)releaseId2, (Object)reply.getResult());
        ServiceResponse disposeReply = this.client.disposeContainer("update-releaseId");
        KieServerAssert.assertSuccess((ServiceResponse)disposeReply);
    }

    @Test
    public void testDisposeContainer() throws Exception {
        this.client.createContainer("dispose-container", new KieContainerResource("dispose-container", releaseId1));
        ServiceResponse reply = this.client.disposeContainer("dispose-container");
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        ServiceResponse listReply = this.client.listContainers();
        KieServerAssert.assertSuccess((ServiceResponse)listReply);
        List containers = ((KieContainerResourceList)listReply.getResult()).getContainers();
        KieServerAssert.assertNullOrEmpty((String)"No containers returned!", (Collection)containers);
    }

    @Test
    public void testDisposeNonExistingContainer() throws Exception {
        ServiceResponse reply = this.client.disposeContainer("non-existing-container");
        KieServerAssert.assertSuccess((ServiceResponse)reply);
    }

    @Test
    public void testUpdateReleaseIdForNotExistingContainer() throws Exception {
        ServiceResponse reply = this.client.updateReleaseId("update-releaseId", releaseId2);
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        Assert.assertEquals((Object)releaseId2, (Object)reply.getResult());
        ServiceResponse replyList = this.client.listContainers();
        KieServerAssert.assertSuccess((ServiceResponse)replyList);
        List containers = ((KieContainerResourceList)replyList.getResult()).getContainers();
        Assert.assertEquals((String)"Number of listed containers!", (long)1L, (long)containers.size());
        this.assertContainsContainer(containers, "update-releaseId");
        ServiceResponse disposeReply = this.client.disposeContainer("update-releaseId");
        KieServerAssert.assertSuccess((ServiceResponse)disposeReply);
    }

    @Test
    public void testUpdateReleaseIdForExistingContainerAndCheckServerState() throws Exception {
        this.client.createContainer("update-releaseId", new KieContainerResource("update-releaseId", releaseId1));
        ServiceResponse reply = this.client.updateReleaseId("update-releaseId", releaseId2);
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        Assert.assertEquals((Object)releaseId2, (Object)reply.getResult());
        ServiceResponse currentServerStateReply = this.client.getServerState();
        KieServerAssert.assertSuccess((ServiceResponse)currentServerStateReply);
        KieServerStateInfo currentServerState = (KieServerStateInfo)currentServerStateReply.getResult();
        Assert.assertNotNull((Object)currentServerState);
        Set containers = currentServerState.getContainers();
        Assert.assertEquals((long)1L, (long)containers.size());
        KieContainerResource container = (KieContainerResource)containers.iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)releaseId2, (Object)container.getReleaseId());
        Assert.assertEquals((Object)releaseId2, (Object)container.getResolvedReleaseId());
        ServiceResponse disposeReply = this.client.disposeContainer("update-releaseId");
        KieServerAssert.assertSuccess((ServiceResponse)disposeReply);
    }

    private void assertContainsContainer(List<KieContainerResource> containers, String expectedContainerId) {
        for (KieContainerResource container : containers) {
            if (!container.getContainerId().equals(expectedContainerId)) continue;
            return;
        }
        Assert.fail((String)("Container list " + containers + " does not contain expected container with id " + expectedContainerId));
    }
}

