/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

public class KieServerIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    private static ReleaseId releaseId1 = new ReleaseId("foo.bar", "baz", "2.1.0.GA");
    private static final String CONTAINER_ID = "kie1";

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.createAndDeployKJar((ReleaseId)releaseId1);
    }

    @Test
    public void testGetServerInfo() throws Exception {
        ServiceResponse reply = this.client.getServerInfo();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieServerInfo info = (KieServerInfo)reply.getResult();
        Assert.assertEquals((Object)this.getServerVersion(), (Object)info.getVersion());
    }

    private String getServerVersion() {
        return System.getProperty("kie.server.version", KieServerEnvironment.getVersion().toString());
    }

    @Before
    public void setupKieServer() {
        KieServerIntegrationTest.disposeAllContainers();
        KieServerIntegrationTest.createContainer((String)CONTAINER_ID, (ReleaseId)releaseId1);
    }

    @Test
    public void testScanner() throws Exception {
        ServiceResponse si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
    }

    @Test
    public void testScannerScanNow() throws Exception {
        ServiceResponse si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.SCANNING, Long.valueOf(0L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.getScannerInfo(CONTAINER_ID);
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
    }

    @Test
    public void testScannerStatusOnContainerInfo() throws Exception {
        ServiceResponse reply = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieContainerResource kci = (KieContainerResource)reply.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)kci.getScanner().getStatus());
        ServiceResponse si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo(CONTAINER_ID).getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)kci.getScanner().getStatus());
        Assert.assertEquals((long)10000L, (long)kci.getScanner().getPollInterval());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo(CONTAINER_ID).getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)kci.getScanner().getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo(CONTAINER_ID).getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)kci.getScanner().getStatus());
    }

    @Test
    public void testScannerStartAndStop() throws Exception {
        ServiceResponse reply = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieContainerResource kci = (KieContainerResource)reply.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)kci.getScanner().getStatus());
        ServiceResponse si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo(CONTAINER_ID).getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)kci.getScanner().getStatus());
        Assert.assertEquals((long)20L, (long)kci.getScanner().getPollInterval());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(20L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo(CONTAINER_ID).getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)kci.getScanner().getStatus());
        si = this.client.updateScanner(CONTAINER_ID, new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        kci = (KieContainerResource)this.client.getContainerInfo(CONTAINER_ID).getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)kci.getScanner().getStatus());
        Assert.assertEquals((long)20L, (long)kci.getScanner().getPollInterval());
    }

    @Test
    public void testConversationIdHandling() throws Exception {
        this.client.getContainerInfo(CONTAINER_ID);
        String conversationId = this.client.getConversationId();
        Assert.assertNotNull((Object)conversationId);
        this.client.getContainerInfo(CONTAINER_ID);
        String afterNextCallConversationId = this.client.getConversationId();
        Assert.assertEquals((Object)conversationId, (Object)afterNextCallConversationId);
        this.client.completeConversation();
        this.client.getContainerInfo(CONTAINER_ID);
        afterNextCallConversationId = this.client.getConversationId();
        Assert.assertNotEquals((Object)conversationId, (Object)afterNextCallConversationId);
    }
}

