/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerKey;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.client.exception.UnexpectedResponseCodeException;
import org.kie.server.integrationtests.shared.filter.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerMgmtControllerClient {
    private static Logger logger = LoggerFactory.getLogger(KieServerMgmtControllerClient.class);
    private static final String MANAGEMENT_LAST_URI_PART = "/management/servers";
    private static final String CONTAINERS_LAST_URI_PART = "/containers";
    private static final String MANAGEMENT_URI_PART = "/management/servers/";
    private static final String CONTAINERS_URI_PART = "/containers/";
    private static final String STARTED_STATUS_URI_PART = "/status/started";
    private static final String STOPPED_STATUS_URI_PART = "/status/stopped";
    private static final String CONFIG_URI_PART = "/config/";
    private String controllerBaseUrl;
    private static final MarshallingFormat DEFAULT_MARSHALLING_FORMAT = MarshallingFormat.JAXB;
    private MarshallingFormat format;
    private Client httpClient;
    protected Marshaller marshaller;

    public KieServerMgmtControllerClient(String controllerBaseUrl, String login, String password) {
        this(controllerBaseUrl, login, password, DEFAULT_MARSHALLING_FORMAT);
    }

    public KieServerMgmtControllerClient(String controllerBaseUrl, String login, String password, MarshallingFormat format) {
        this.controllerBaseUrl = controllerBaseUrl;
        this.httpClient = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(10L, TimeUnit.SECONDS).build();
        if (login == null) {
            login = TestConfig.getUsername();
            password = TestConfig.getPassword();
        }
        this.httpClient.register((Object)new Authenticator(login, password));
        this.setMarshallingFormat(format);
    }

    public ServerTemplate getServerTemplate(String serverTemplateId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId, ServerTemplate.class);
    }

    public void saveContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerSpec.getId(), containerSpec, Object.class);
    }

    public void updateContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerSpec.getId(), containerSpec, Object.class);
    }

    public void saveServerTemplate(ServerTemplate serverTemplate) {
        this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplate.getId(), serverTemplate, Object.class);
    }

    public void deleteServerTemplate(String serverTemplateId) {
        this.makeDeleteRequest(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId);
    }

    public ContainerSpec getContainerInfo(String serverTemplateId, String containerId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId, ContainerSpec.class);
    }

    public void deleteContainerSpec(String serverTemplateId, String containerId) {
        this.makeDeleteRequest(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId);
    }

    public Collection<ServerTemplate> listServerTemplates() {
        ServerTemplateList serverTemplateList = this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_LAST_URI_PART, ServerTemplateList.class);
        if (serverTemplateList != null && serverTemplateList.getServerTemplates() != null) {
            return Arrays.asList(serverTemplateList.getServerTemplates());
        }
        return Collections.emptyList();
    }

    public Collection<ContainerSpec> listContainerSpec(String serverTemplateId) {
        ContainerSpecList containerSpecList = this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_LAST_URI_PART, ContainerSpecList.class);
        if (containerSpecList != null && containerSpecList.getContainerSpecs() != null) {
            return Arrays.asList(containerSpecList.getContainerSpecs());
        }
        return Collections.emptyList();
    }

    public void startContainer(String serverTemplateId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + STARTED_STATUS_URI_PART, "", null);
    }

    public void stopContainer(String serverTemplateId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + STOPPED_STATUS_URI_PART, "", null);
    }

    public void updateContainerConfig(String serverTemplateId, String containerId, Capability capability, ContainerConfig config) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + CONFIG_URI_PART + capability.toString(), config, Object.class);
    }

    private <T> T makeGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        WebTarget clientRequest = this.httpClient.target(uri);
        Response response = clientRequest.request(new String[]{this.getMediaType(this.format)}).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private void makeDeleteRequest(String uri) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).delete();
            response.close();
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
    }

    private <T> T makePutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            Entity requestEntity = Entity.entity((Object)this.serialize(bodyObject), (String)this.getMediaType(this.format));
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).put(requestEntity);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private <T> T makePostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            Entity requestEntity = Entity.entity((Object)this.serialize(bodyObject), (String)this.getMediaType(this.format));
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).post(requestEntity);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode() || response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(WebTarget request, Response response) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unexpected HTTP response code when requesting URI '");
        stringBuffer.append(this.getClientRequestUri(request));
        stringBuffer.append("'! Response code: ");
        stringBuffer.append(response.getStatus());
        try {
            String responseEntity = (String)response.readEntity(String.class);
            stringBuffer.append(" Response message: ");
            stringBuffer.append(responseEntity);
        }
        catch (IllegalStateException e) {
            response.close();
        }
        logger.debug(stringBuffer.toString());
        return new UnexpectedResponseCodeException(response.getStatus(), stringBuffer.toString());
    }

    private RuntimeException createExceptionForUnexpectedFailure(WebTarget request, Exception e) {
        String summaryMessage = "Unexpected exception when requesting URI '" + this.getClientRequestUri(request) + "'!";
        logger.debug(summaryMessage);
        return new RuntimeException(summaryMessage, e);
    }

    private String getClientRequestUri(WebTarget clientRequest) {
        String uri;
        try {
            uri = clientRequest.getUri().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed client URL was specified!", e);
        }
        return uri;
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.error("Exception thrown while closing resources!", (Throwable)e);
        }
    }

    public MarshallingFormat getMarshallingFormat() {
        return this.format;
    }

    public void setMarshallingFormat(MarshallingFormat format) {
        this.format = format;
        HashSet<Class> controllerClasses = new HashSet<Class>();
        controllerClasses.add(KieServerInstance.class);
        controllerClasses.add(KieServerInstanceList.class);
        controllerClasses.add(KieServerInstanceInfo.class);
        controllerClasses.add(KieServerSetup.class);
        controllerClasses.add(KieServerStatus.class);
        controllerClasses.add(ServerInstance.class);
        controllerClasses.add(ServerInstanceKey.class);
        controllerClasses.add(ServerTemplate.class);
        controllerClasses.add(ServerTemplateKey.class);
        controllerClasses.add(ServerConfig.class);
        controllerClasses.add(RuleConfig.class);
        controllerClasses.add(ProcessConfig.class);
        controllerClasses.add(ContainerSpec.class);
        controllerClasses.add(ContainerSpecKey.class);
        controllerClasses.add(Container.class);
        controllerClasses.add(ContainerKey.class);
        controllerClasses.add(ServerTemplateList.class);
        controllerClasses.add(ContainerSpecList.class);
        HashSet<Class> minimalControllerClasses = new HashSet<Class>();
        minimalControllerClasses.add(RuleConfig.class);
        minimalControllerClasses.add(ProcessConfig.class);
        switch (format) {
            case JAXB: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerMgmtControllerClient.class.getClassLoader());
                break;
            }
            case JSON: {
                this.marshaller = MarshallerFactory.getMarshaller(minimalControllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerMgmtControllerClient.class.getClassLoader());
                break;
            }
            default: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerMgmtControllerClient.class.getClassLoader());
            }
        }
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(Response response, Class<T> type) {
        try {
            if (type == null) {
                T t = null;
                return t;
            }
            String content = (String)response.readEntity(String.class);
            logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
            if (content == null || content.isEmpty()) {
                T t = null;
                return t;
            }
            Object object = this.marshaller.unmarshall(content, type);
            return (T)object;
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while deserializing data received from server!", e);
        }
        finally {
            response.close();
        }
    }

    public static <T> Class<T> castClass(Class<?> aClass) {
        return aClass;
    }
}

