/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common.rest;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.category.RESTOnly;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.RestOnlyBaseIntegrationTest;

@Category(value={RESTOnly.class})
public class RestMalformedRequestIntegrationTest
extends RestOnlyBaseIntegrationTest {
    @Test
    public void testCreateContainerNonExistingGAV2() throws Exception {
        KieContainerResource resource = new KieContainerResource("no-gav2-container", new ReleaseId("foo", "bar", "0.0.0"));
        try (Response response = null;){
            WebTarget clientRequest = this.newRequest(TestConfig.getKieServerHttpUrl() + "/containers/" + resource.getContainerId());
            response = clientRequest.request(new MediaType[]{this.getMediaType()}).put(this.createEntity(resource));
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        }
    }

    @Test
    public void testCreateContainerEmptyBody() throws Exception {
        try (Response response = null;){
            WebTarget clientRequest = this.newRequest(TestConfig.getKieServerHttpUrl() + "/containers/empty-body-container");
            response = clientRequest.request(new MediaType[]{this.getMediaType()}).put(this.createEntity(""));
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        }
    }
}

