/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.BasicAuthentication;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;

public abstract class RestTextOnlyBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    private MarshallingFormat marshallingFormat = MarshallingFormat.XSTREAM;
    private KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    private static Client httpClient;

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        return this.createDefaultClient(this.configuration, this.marshallingFormat);
    }

    protected MediaType getMediaType() {
        return MediaType.TEXT_PLAIN_TYPE;
    }

    protected WebTarget newRequest(String uriString) {
        if (httpClient == null) {
            httpClient = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(10L, TimeUnit.SECONDS).build();
        }
        WebTarget webTarget = httpClient.target(uriString);
        webTarget.register((Object)new BasicAuthentication(this.configuration.getUserName(), this.configuration.getPassword()));
        return webTarget;
    }
}

