/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.router.client;

import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.controller.client.exception.KieServerControllerHTTPClientException;
import org.kie.server.router.Configuration;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerRouterClient
implements AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(KieServerRouterClient.class);
    private static final String MANAGEMENT_LIST_URI_PART = "/mgmt/list";
    private String routerBaseUrl;
    private Client httpClient;
    private String mediaType = "application/json";
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();

    public KieServerRouterClient(String routerBaseUrl) {
        this.routerBaseUrl = routerBaseUrl;
        this.httpClient = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(10L, TimeUnit.SECONDS).build();
    }

    public Configuration getRouterConfig() {
        return this.makeGetRequestAndCreateCustomResponse(this.routerBaseUrl + MANAGEMENT_LIST_URI_PART);
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.error("Exception thrown while closing resources!", (Throwable)e);
        }
    }

    private Configuration makeGetRequestAndCreateCustomResponse(String uri) {
        WebTarget clientRequest = this.httpClient.target(uri);
        Response response = clientRequest.request(new String[]{this.mediaType}).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(WebTarget request, Response response) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unexpected HTTP response code when requesting URI '");
        stringBuffer.append(this.getClientRequestUri(request));
        stringBuffer.append("'! Response code: ");
        stringBuffer.append(response.getStatus());
        try {
            String responseEntity = (String)response.readEntity(String.class);
            stringBuffer.append(" Response message: ");
            stringBuffer.append(responseEntity);
        }
        catch (IllegalStateException e) {
            response.close();
        }
        logger.debug(stringBuffer.toString());
        return new KieServerControllerHTTPClientException(response.getStatus(), stringBuffer.toString());
    }

    private String getClientRequestUri(WebTarget clientRequest) {
        String uri;
        try {
            uri = clientRequest.getUri().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed client URL was specified!", e);
        }
        return uri;
    }

    private Configuration deserialize(Response response) {
        try {
            String content = (String)response.readEntity(String.class);
            logger.debug("About to deserialize content: \n '{}'", (Object)content);
            if (content == null || content.isEmpty()) {
                Configuration configuration = null;
                return configuration;
            }
            Configuration configuration = this.marshaller.unmarshall((Reader)new StringReader(content));
            return configuration;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while deserializing data received from server!", e);
        }
        finally {
            response.close();
        }
    }
}

