/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Configuration;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieControllerExecutor;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerExecutor;
import org.kie.server.integrationtests.shared.KieServerRouterExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerBaseIntegrationTest {
    protected static Logger logger = LoggerFactory.getLogger(KieServerBaseIntegrationTest.class);
    protected KieServicesClient client;
    protected static KieControllerExecutor controller;
    protected static KieServerExecutor server;
    protected static KieServerRouterExecutor router;
    protected static final long DEFAULT_TIMEOUT = 60000L;
    protected Map<String, Class<?>> extraClasses = new ConcurrentHashMap();

    @BeforeClass
    public static void setupClass() throws Exception {
        KieServerBaseIntegrationTest.setupClass("KeepLatestOnly");
    }

    public static void setupClass(String oldServerActivePolicy) throws Exception {
        router = new KieServerRouterExecutor();
        router.startKieRouter();
        if (TestConfig.isLocalServer()) {
            controller = new KieControllerExecutor();
            controller.startKieController();
            server = new KieServerExecutor();
            server.setServerActivePolicies(oldServerActivePolicy);
            server.startKieServer();
        }
        KieServerBaseIntegrationTest.setupCustomSettingsXml();
        KieServerBaseIntegrationTest.disposeAllContainers();
    }

    private static void setupCustomSettingsXml() {
        if (!TestConfig.isLocalServer()) {
            String deploymentSettings = TestConfig.getKieClientDeploymentSettings();
            if (deploymentSettings == null) {
                deploymentSettings = KieServerBaseIntegrationTest.class.getResource("/kie-server-testing-client-deployment-settings.xml").getFile();
            }
            System.setProperty("kie.maven.settings.custom", deploymentSettings);
        }
    }

    @Before
    public void setup() throws Exception {
        this.client = this.createDefaultClient();
    }

    @AfterClass
    public static void tearDown() {
        if (TestConfig.isLocalServer()) {
            server.stopKieServer();
            controller.stopKieController();
            System.clearProperty("java.naming.factory.initial");
        }
        router.stopKieRouter();
    }

    protected static void disposeAllContainers() {
        KieServicesClient client = KieServerBaseIntegrationTest.createDefaultStaticClient();
        ServiceResponse response = client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        List containers = ((KieContainerResourceList)response.getResult()).getContainers();
        if (containers != null) {
            for (KieContainerResource container : containers) {
                KieServerAssert.assertSuccess(client.disposeContainer(container.getContainerId()));
            }
        }
    }

    protected static void createContainer(String containerId, ReleaseId releaseId) {
        KieServerBaseIntegrationTest.createContainer(containerId, releaseId, null);
    }

    protected static void createContainer(String containerId, ReleaseId releaseId, KieServerConfigItem ... configItems) {
        KieServerBaseIntegrationTest.createContainer(containerId, releaseId, null, configItems);
    }

    protected static void createContainer(String containerId, ReleaseId releaseId, String alias, KieServerConfigItem ... configItems) {
        KieServicesClient client = KieServerBaseIntegrationTest.createDefaultStaticClient();
        KieContainerResource containerResource = new KieContainerResource(containerId, releaseId);
        containerResource.setContainerAlias(alias);
        if (configItems != null && configItems.length > 0) {
            containerResource.setConfigItems(Arrays.asList(configItems));
        }
        ServiceResponse reply = client.createContainer(containerId, containerResource);
        Assume.assumeTrue((boolean)reply.getType().equals((Object)KieServiceResponse.ResponseType.SUCCESS));
    }

    protected void disposeAllServerInstances() {
        if (TestConfig.isLocalServer() || TestConfig.isControllerProvided()) {
            this.disposeServerTemplates();
        }
    }

    private void disposeServerTemplates() {
        Configuration configuration = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(60L, TimeUnit.SECONDS).getConfiguration();
        try (KieServerControllerClient mgmtControllerClient = TestConfig.isLocalServer() ? KieServerControllerClientFactory.newRestClient((String)TestConfig.getControllerHttpUrl(), null, null, (MarshallingFormat)MarshallingFormat.JAXB, (Configuration)configuration) : KieServerControllerClientFactory.newRestClient((String)TestConfig.getControllerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword(), (MarshallingFormat)MarshallingFormat.JAXB, (Configuration)configuration);){
            ServerTemplateList serverTemplates = mgmtControllerClient.listServerTemplates();
            if (serverTemplates.getServerTemplates() != null) {
                for (ServerTemplate serverTemplate : serverTemplates.getServerTemplates()) {
                    mgmtControllerClient.deleteServerTemplate(serverTemplate.getId());
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error while deleting server templates: ", (Object)ex.getMessage(), (Object)ex);
        }
    }

    protected abstract KieServicesClient createDefaultClient() throws Exception;

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }

    protected KieServicesClient createDefaultClient(KieServicesConfiguration configuration, MarshallingFormat marshallingFormat) throws Exception {
        KieServicesClient kieServicesClient = null;
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(marshallingFormat);
        configuration.addExtraClasses(new HashSet(this.extraClasses.values()));
        this.additionalConfiguration(configuration);
        if (this.extraClasses.size() > 0) {
            ClassLoader classLoader = this.extraClasses.values().iterator().next().getClassLoader();
            kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)classLoader);
        } else {
            kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        }
        this.setupClients(kieServicesClient);
        return kieServicesClient;
    }

    protected static KieServicesClient createDefaultStaticClient() {
        return KieServerBaseIntegrationTest.createDefaultStaticClient(60000L);
    }

    protected static KieServicesClient createDefaultStaticClient(long timeout) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword(), (long)timeout);
        configuration.setMarshallingFormat(MarshallingFormat.JAXB);
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        return kieServicesClient;
    }

    protected static KieServicesClient createDefaultStaticClient(long timeout, ClassLoader classLoader) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword(), (long)timeout);
        configuration.setMarshallingFormat(MarshallingFormat.JAXB);
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)classLoader);
        return kieServicesClient;
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    protected void additionalConfiguration(KieServicesConfiguration configuration) throws Exception {
    }

    protected void setupClients(KieServicesClient kieServicesClient) {
    }

    static {
        if (TestConfig.isLocalServer()) {
            System.setProperty("java.naming.factory.initial", "org.jbpm.test.util.CloseSafeMemoryContextFactory");
            System.setProperty("org.osjava.sj.root", "target/test-classes/config");
            System.setProperty("org.osjava.jndi.delimiter", "/");
            System.setProperty("org.osjava.sj.jndi.shared", "true");
        }
    }
}

