/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.kie.api.KieServices;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;

public class KieServerExecutor {
    protected TJWSEmbeddedJaxrsServer server;
    private KieServerImpl kieServer;
    private int kieServerAllocatedPort;
    private String serverActivePolicies = "KeepLatestOnly";
    private static SimpleDateFormat serverIdSuffixDateFormat = new SimpleDateFormat("yyyy-MM-DD-HHmmss_SSS");

    public KieServerExecutor() {
        this(TestConfig.getKieServerAllocatedPort());
    }

    public KieServerExecutor(int kieServerAllocatedPort) {
        this.kieServerAllocatedPort = kieServerAllocatedPort;
    }

    public void startKieServer() {
        this.startKieServer(false);
    }

    public void startKieServer(boolean syncWithController) {
        if (this.server != null) {
            throw new RuntimeException("Kie execution server is already created!");
        }
        this.registerKieServerId();
        this.setKieServerProperties(syncWithController);
        this.server = new TJWSEmbeddedJaxrsServer();
        this.server.setPort(this.kieServerAllocatedPort);
        this.server.start();
        this.addServerSingletonResources();
    }

    public void setServerActivePolicies(String serverActivePolicies) {
        this.serverActivePolicies = serverActivePolicies;
    }

    protected void setKieServerProperties(boolean syncWithController) {
        System.setProperty("org.kie.server.bypass.auth.user", "true");
        System.setProperty("org.jbpm.ht.callback", "custom");
        System.setProperty("org.jbpm.ht.custom.callback", "org.kie.server.integrationtests.jbpm.util.FixedUserGroupCallbackImpl");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm-ds");
        System.setProperty("org.kie.server.persistence.tm", "JBossTS");
        System.setProperty("org.kie.server.controller", TestConfig.getControllerHttpUrl());
        System.setProperty("org.kie.server.controller.user", TestConfig.getUsername());
        System.setProperty("org.kie.server.controller.pwd", TestConfig.getPassword());
        System.setProperty("org.kie.server.location", "http://localhost:" + this.kieServerAllocatedPort + "/server");
        System.setProperty("org.kie.server.repo", "./target");
        System.setProperty("org.kie.server.sync.deploy", Boolean.toString(syncWithController));
        System.setProperty("org.kie.server.mode", KieServerMode.PRODUCTION.name());
        System.setProperty("org.kie.server.policy.activate", this.serverActivePolicies);
        System.setProperty("policy.klo.interval", "5000");
    }

    private void registerKieServerId() {
        if (KieServerEnvironment.getServerId() == null) {
            KieServerEnvironment.setServerId((String)(KieServerBaseIntegrationTest.class.getSimpleName() + "@" + serverIdSuffixDateFormat.format(new Date())));
            KieServerEnvironment.setServerName((String)"KieServer");
        }
    }

    private void addServerSingletonResources() {
        this.kieServer = new KieServerImpl();
        this.kieServer.init();
        this.server.getDeployment().getRegistry().addSingletonResource((Object)new KieServerRestImpl(this.kieServer));
        List extensions = this.kieServer.getServerExtensions();
        for (KieServerExtension extension : extensions) {
            List components = extension.getAppComponents(SupportedTransports.REST);
            for (Object component : components) {
                this.server.getDeployment().getRegistry().addSingletonResource(component);
            }
        }
    }

    public void stopKieServer() {
        if (this.server == null) {
            throw new RuntimeException("Kie execution server is already stopped!");
        }
        this.kieServer.destroy();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        this.server.stop();
        this.server = null;
    }
}

