/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.common.jms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.jms.AsyncResponseHandler;
import org.kie.server.client.jms.BlockingResponseCallback;
import org.kie.server.client.jms.FireAndForgetResponseHandler;
import org.kie.server.client.jms.ResponseCallback;
import org.kie.server.client.jms.ResponseHandler;
import org.kie.server.integrationtests.category.JMSOnly;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerSynchronization;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

@Category(value={JMSOnly.class})
public class ContainerJmsResponseHandlerIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    private static final ReleaseId RELEASE_ID_1 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.0.GA");
    private static final ReleaseId RELEASE_ID_2 = new ReleaseId("org.kie.server.testing", "container-crud-tests1", "2.1.1.GA");
    private KieServicesClient asyncClient;
    private ResponseCallback responseCallback;
    private KieServicesClient fireAndForgetClient;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration jmsConfiguration = ContainerJmsResponseHandlerIntegrationTest.createKieServicesJmsConfiguration();
        return new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB, jmsConfiguration}, {MarshallingFormat.JSON, jmsConfiguration}, {MarshallingFormat.XSTREAM, jmsConfiguration}));
    }

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.createAndDeployKJar((ReleaseId)RELEASE_ID_1);
        KieServerDeployer.createAndDeployKJar((ReleaseId)RELEASE_ID_2);
    }

    @Before
    public void setupClients() throws Exception {
        this.asyncClient = this.createDefaultClient();
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(this.extraClasses.values()), (MarshallingFormat)this.configuration.getMarshallingFormat(), (ClassLoader)this.asyncClient.getClassLoader());
        this.responseCallback = new BlockingResponseCallback(marshaller);
        this.asyncClient.setResponseHandler((ResponseHandler)new AsyncResponseHandler(this.responseCallback));
        this.fireAndForgetClient = this.createDefaultClient();
        this.fireAndForgetClient.setResponseHandler((ResponseHandler)new FireAndForgetResponseHandler());
    }

    @Before
    public void setupKieServer() throws Exception {
        ContainerJmsResponseHandlerIntegrationTest.disposeAllContainers();
    }

    @Test
    public void testContainerWithAsyncResponseHandler() {
        String containerId = "asyncContainer";
        ServiceResponse response = this.asyncClient.createContainer(containerId, new KieContainerResource(containerId, RELEASE_ID_1));
        Assertions.assertThat((Object)response).isNull();
        KieContainerResource container = (KieContainerResource)this.responseCallback.get(KieContainerResource.class);
        Assertions.assertThat((Object)container).isNotNull();
        Assertions.assertThat((String)container.getContainerId()).isEqualTo(containerId);
        Assertions.assertThat((Comparable)container.getReleaseId()).isEqualTo((Object)RELEASE_ID_1);
        response = this.asyncClient.getServerState();
        Assertions.assertThat((Object)response).isNull();
        KieServerStateInfo serverState = (KieServerStateInfo)this.responseCallback.get(KieServerStateInfo.class);
        Assertions.assertThat((Object)serverState).isNotNull();
        Assertions.assertThat((Iterable)serverState.getContainers()).hasSize(1);
        container = (KieContainerResource)serverState.getContainers().iterator().next();
        Assertions.assertThat((Comparable)container.getReleaseId()).isEqualTo((Object)RELEASE_ID_1);
        response = this.asyncClient.updateReleaseId(containerId, RELEASE_ID_2);
        Assertions.assertThat((Object)response).isNull();
        ReleaseId releaseId = (ReleaseId)this.responseCallback.get(ReleaseId.class);
        Assertions.assertThat((Comparable)releaseId).isEqualTo((Object)RELEASE_ID_2);
        response = this.asyncClient.getContainerInfo(containerId);
        Assertions.assertThat((Object)response).isNull();
        container = (KieContainerResource)this.responseCallback.get(KieContainerResource.class);
        Assertions.assertThat((Comparable)container.getReleaseId()).isEqualTo((Object)RELEASE_ID_2);
        response = this.asyncClient.disposeContainer(containerId);
        Assertions.assertThat((Object)response).isNull();
        this.responseCallback.get(Void.class);
        response = this.asyncClient.listContainers();
        Assertions.assertThat((Object)response).isNull();
        KieContainerResourceList containerList = (KieContainerResourceList)this.responseCallback.get(KieContainerResourceList.class);
        Assertions.assertThat((List)containerList.getContainers()).isNullOrEmpty();
    }

    @Test
    public void testContainerWithFireAndForgetResponseHandler() throws Exception {
        String containerId = "fireAndForgetContainer";
        ServiceResponse response = this.fireAndForgetClient.createContainer(containerId, new KieContainerResource(containerId, RELEASE_ID_1));
        Assertions.assertThat((Object)response).isNull();
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        response = this.fireAndForgetClient.updateReleaseId(containerId, RELEASE_ID_2);
        Assertions.assertThat((Object)response).isNull();
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID_2);
        response = this.fireAndForgetClient.disposeContainer(containerId);
        Assertions.assertThat((Object)response).isNull();
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)0);
    }

    @Test
    public void testScannerWithAsyncResponseHandler() {
        String containerId = "asyncScannerContainer";
        ContainerJmsResponseHandlerIntegrationTest.createContainer((String)containerId, (ReleaseId)RELEASE_ID_1);
        ServiceResponse response = this.asyncClient.updateScanner(containerId, new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assertions.assertThat((Object)response).isNull();
        KieScannerResource scanner = (KieScannerResource)this.responseCallback.get(KieScannerResource.class);
        Assertions.assertThat((Comparable)scanner.getStatus()).isEqualTo((Object)KieScannerStatus.STARTED);
        response = this.asyncClient.updateScanner(containerId, new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assertions.assertThat((Object)response).isNull();
        scanner = (KieScannerResource)this.responseCallback.get(KieScannerResource.class);
        Assertions.assertThat((Comparable)scanner.getStatus()).isEqualTo((Object)KieScannerStatus.STOPPED);
        response = this.asyncClient.updateScanner(containerId, new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assertions.assertThat((Object)response).isNull();
        scanner = (KieScannerResource)this.responseCallback.get(KieScannerResource.class);
        Assertions.assertThat((Comparable)scanner.getStatus()).isEqualTo((Object)KieScannerStatus.DISPOSED);
    }

    @Test
    public void testScannerWithFireAndForgetResponseHandler() throws Exception {
        String containerId = "fireAndForgetScannerContainer";
        ContainerJmsResponseHandlerIntegrationTest.createContainer((String)containerId, (ReleaseId)RELEASE_ID_1);
        ServiceResponse response = this.fireAndForgetClient.updateScanner(containerId, new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assertions.assertThat((Object)response).isNull();
        KieServerSynchronization.waitForContainerWithScannerStatus((KieServicesClient)this.client, (KieScannerStatus)KieScannerStatus.STARTED);
        response = this.asyncClient.updateScanner(containerId, new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assertions.assertThat((Object)response).isNull();
        KieServerSynchronization.waitForContainerWithScannerStatus((KieServicesClient)this.client, (KieScannerStatus)KieScannerStatus.STOPPED);
        response = this.asyncClient.updateScanner(containerId, new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assertions.assertThat((Object)response).isNull();
        KieServerSynchronization.waitForContainerWithScannerStatus((KieServicesClient)this.client, (KieScannerStatus)KieScannerStatus.DISPOSED);
    }
}

