/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestConfig.class);
    private static Integer ALLOCATED_PORT;
    private static Integer CONTROLLER_ALLOCATED_PORT;
    private static Integer ROUTER_ALLOCATED_PORT;
    private static final StringTestParameter PROVIDED_HTTP_URL;
    private static final StringTestParameter PROVIDED_CONTEXT;
    private static final StringTestParameter PROVIDED_CONTROLLER_HTTP_URL;
    private static final StringTestParameter PROVIDED_CONTROLLER_CONTEXT;
    private static final StringTestParameter USERNAME;
    private static final StringTestParameter PASSWORD;
    private static final StringTestParameter INITIAL_CONTEXT_FACTORY;
    private static final StringTestParameter CONNECTION_FACTORY;
    private static final StringTestParameter REMOTING_URL;
    private static final StringTestParameter REQUEST_QUEUE_JNDI;
    private static final StringTestParameter RESPONSE_QUEUE_JNDI;
    private static final StringTestParameter KJARS_BUILD_SETTINGS_XML;
    private static final StringTestParameter KIE_CLIENT_DEPLOYMENT_SETTINGS;
    private static final StringTestParameter KIE_SERVER_MAVEN_SETTINGS;
    private static final StringTestParameter CONTAINER_ID;
    private static final StringTestParameter CONTAINER_PORT;
    private static final StringTestParameter CARGO_REMOTE_USERNAME;
    private static final StringTestParameter CARGO_REMOTE_PASSWORD;
    private static final StringTestParameter KIE_SERVER_WAR_PATH;
    private static final StringTestParameter WEBLOGIC_HOME;
    private static final StringTestParameter JMS_SKIP;
    private static final StringTestParameter ORG_KIE_SERVER_DATASOURCE_DRIVER_CLASS;

    public static String getKieServerHttpUrl() {
        String httpUrl = "";
        httpUrl = PROVIDED_HTTP_URL.isParameterConfigured() ? (String)PROVIDED_HTTP_URL.getParameterValue() : TestConfig.getEmbeddedKieServerHttpUrl();
        return httpUrl;
    }

    public static String getEmbeddedKieServerHttpUrl() {
        return "http://localhost:" + TestConfig.getKieServerAllocatedPort() + "/server";
    }

    public static String getControllerHttpUrl() {
        String httpUrl = "";
        httpUrl = PROVIDED_CONTROLLER_HTTP_URL.isParameterConfigured() ? (String)PROVIDED_CONTROLLER_HTTP_URL.getParameterValue() : "http://localhost:" + TestConfig.getControllerAllocatedPort() + "/controller";
        return httpUrl;
    }

    public static String getControllerWebSocketManagementUrl() {
        try {
            URL controllerUrl = new URL(TestConfig.getControllerHttpUrl());
            return String.format("ws://%s:%s/%s/websocket/controller", controllerUrl.getHost(), controllerUrl.getPort(), TestConfig.getKieServerControllerContext());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create controller Web Socket URL", ex);
        }
    }

    public static boolean isControllerProvided() {
        return PROVIDED_CONTROLLER_HTTP_URL.isParameterConfigured();
    }

    public static Integer getKieServerAllocatedPort() {
        if (ALLOCATED_PORT == null) {
            try {
                ServerSocket server = new ServerSocket(0);
                ALLOCATED_PORT = server.getLocalPort();
                server.close();
            }
            catch (IOException e) {
                ALLOCATED_PORT = 9789;
            }
            LOGGER.debug("Allocating port {}.", (Object)ALLOCATED_PORT);
        }
        return ALLOCATED_PORT;
    }

    public static Integer getControllerAllocatedPort() {
        if (CONTROLLER_ALLOCATED_PORT == null) {
            try {
                ServerSocket server = new ServerSocket(0);
                CONTROLLER_ALLOCATED_PORT = server.getLocalPort();
                server.close();
            }
            catch (IOException e) {
                CONTROLLER_ALLOCATED_PORT = 9689;
            }
            LOGGER.debug("Allocating port {}.", (Object)CONTROLLER_ALLOCATED_PORT);
        }
        return CONTROLLER_ALLOCATED_PORT;
    }

    public static Integer getRouterAllocatedPort() {
        if (ROUTER_ALLOCATED_PORT == null) {
            try {
                ServerSocket server = new ServerSocket(0);
                ROUTER_ALLOCATED_PORT = server.getLocalPort();
                server.close();
            }
            catch (IOException e) {
                ROUTER_ALLOCATED_PORT = 9765;
            }
            LOGGER.debug("Allocating port for router {}.", (Object)ROUTER_ALLOCATED_PORT);
        }
        return ROUTER_ALLOCATED_PORT;
    }

    public static boolean skipJMS() {
        if (TestConfig.class.getResource("/jms.skip") != null) {
            return true;
        }
        if (JMS_SKIP.isParameterConfigured()) {
            String jmsSkip = (String)JMS_SKIP.getParameterValue();
            return Boolean.parseBoolean(jmsSkip);
        }
        return false;
    }

    public static boolean startRouter() {
        return TestConfig.class.getResource("/router.start") != null;
    }

    public static boolean isLocalServer() {
        boolean isLocalServer = true;
        if (PROVIDED_HTTP_URL.isParameterConfigured() || REMOTING_URL.isParameterConfigured() || PROVIDED_CONTROLLER_HTTP_URL.isParameterConfigured()) {
            isLocalServer = false;
        }
        return isLocalServer;
    }

    public static String getUsername() {
        return (String)USERNAME.getParameterValue();
    }

    public static String getPassword() {
        return (String)PASSWORD.getParameterValue();
    }

    public static String getInitialContextFactory() {
        return (String)INITIAL_CONTEXT_FACTORY.getParameterValue();
    }

    public static String getConnectionFactory() {
        return (String)CONNECTION_FACTORY.getParameterValue();
    }

    public static String getRemotingUrl() {
        return (String)REMOTING_URL.getParameterValue();
    }

    public static String getRequestQueueJndi() {
        return (String)REQUEST_QUEUE_JNDI.getParameterValue();
    }

    public static String getResponseQueueJndi() {
        return (String)RESPONSE_QUEUE_JNDI.getParameterValue();
    }

    public static InitialContext getInitialRemoteContext() {
        InitialContext context = null;
        try {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", TestConfig.getInitialContextFactory());
            env.put("java.naming.provider.url", TestConfig.getRemotingUrl());
            env.put("java.naming.security.principal", TestConfig.getUsername());
            env.put("java.naming.security.credentials", TestConfig.getPassword());
            context = new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to create initial context!", e);
        }
        return context;
    }

    public static String getKjarsBuildSettingsXml() {
        return (String)KJARS_BUILD_SETTINGS_XML.getParameterValue();
    }

    public static String getContainerId() {
        return (String)CONTAINER_ID.getParameterValue();
    }

    public static String getKieServerContext() {
        return (String)PROVIDED_CONTEXT.getParameterValue();
    }

    public static String getKieServerControllerContext() {
        return (String)PROVIDED_CONTROLLER_CONTEXT.getParameterValue();
    }

    public static String getKieServerWarPath() {
        return (String)KIE_SERVER_WAR_PATH.getParameterValue();
    }

    public static String getContainerPort() {
        return (String)CONTAINER_PORT.getParameterValue();
    }

    public static String getWebLogicHome() {
        return (String)WEBLOGIC_HOME.getParameterValue();
    }

    public static boolean isWebLogicHomeProvided() {
        return WEBLOGIC_HOME.isParameterConfigured();
    }

    public static String getCargoRemoteUsername() {
        return (String)CARGO_REMOTE_USERNAME.getParameterValue();
    }

    public static boolean isCargoRemoteUsernameProvided() {
        return CARGO_REMOTE_USERNAME.isParameterConfigured();
    }

    public static String getCargoRemotePassword() {
        return (String)CARGO_REMOTE_PASSWORD.getParameterValue();
    }

    public static boolean isCargoRemotePasswordProvided() {
        return CARGO_REMOTE_PASSWORD.isParameterConfigured();
    }

    public static String getKieClientDeploymentSettings() {
        return (String)KIE_CLIENT_DEPLOYMENT_SETTINGS.getParameterValue();
    }

    public static String getKieServerDataSourceDriverClass() {
        return (String)ORG_KIE_SERVER_DATASOURCE_DRIVER_CLASS.getParameterValue();
    }

    public static String getKieServerMavenSettings() {
        return (String)KIE_SERVER_MAVEN_SETTINGS.getParameterValue();
    }

    public static boolean isSybaseDataSource() {
        return TestConfig.getKieServerDataSourceDriverClass().startsWith("com.sybase");
    }

    static {
        LOGGER.info("----- Initializing TestConfig -----");
        PROVIDED_HTTP_URL = new StringTestParameter("kie.server.base.http.url");
        PROVIDED_CONTEXT = new StringTestParameter("kie.server.context");
        PROVIDED_CONTROLLER_HTTP_URL = new StringTestParameter("kie.server.controller.base.http.url");
        PROVIDED_CONTROLLER_CONTEXT = new StringTestParameter("kie.server.controller.context");
        USERNAME = new StringTestParameter("username", "yoda");
        PASSWORD = new StringTestParameter("password", "usetheforce123@");
        INITIAL_CONTEXT_FACTORY = new StringTestParameter("kie.server.context.factory", "org.wildfly.naming.client.WildFlyInitialContextFactory");
        CONNECTION_FACTORY = new StringTestParameter("kie.server.connection.factory", "jms/RemoteConnectionFactory");
        REMOTING_URL = new StringTestParameter("kie.server.remoting.url");
        REQUEST_QUEUE_JNDI = new StringTestParameter("kie.server.jndi.request.queue", "jms/queue/KIE.SERVER.REQUEST");
        RESPONSE_QUEUE_JNDI = new StringTestParameter("kie.server.jndi.response.queue", "jms/queue/KIE.SERVER.RESPONSE");
        KJARS_BUILD_SETTINGS_XML = new StringTestParameter("kie.server.testing.kjars.build.settings.xml");
        KIE_CLIENT_DEPLOYMENT_SETTINGS = new StringTestParameter("kie.server.client.deployment.settings.xml");
        KIE_SERVER_MAVEN_SETTINGS = new StringTestParameter("kie.server.server.deployment.settings.xml");
        CONTAINER_ID = new StringTestParameter("cargo.container.id");
        CONTAINER_PORT = new StringTestParameter("cargo.servlet.port");
        CARGO_REMOTE_USERNAME = new StringTestParameter("cargo.remote.username");
        CARGO_REMOTE_PASSWORD = new StringTestParameter("cargo.remote.password");
        KIE_SERVER_WAR_PATH = new StringTestParameter("kie.server.war.path");
        WEBLOGIC_HOME = new StringTestParameter("weblogic.home");
        JMS_SKIP = new StringTestParameter("jms.skip");
        ORG_KIE_SERVER_DATASOURCE_DRIVER_CLASS = new StringTestParameter("org.kie.server.datasource.driver.class", "org.h2.Driver");
        TreeMap<String, String> params = new TreeMap<String, String>();
        int maxKeyLength = 0;
        for (Field f : TestConfig.class.getDeclaredFields()) {
            if (!TestParameter.class.isAssignableFrom(f.getType())) continue;
            try {
                String paramName = f.getName();
                TestParameter paramValue = (TestParameter)f.get(null);
                maxKeyLength = Math.max(maxKeyLength, paramName.length());
                if (!paramValue.isParameterConfigured()) continue;
                params.put(paramName, paramValue.getParameterValue().toString());
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Cannot read field '{}'.", (Object)f.getName(), (Object)ex);
            }
        }
        for (Map.Entry entry : params.entrySet()) {
            String paramName = (String)entry.getKey();
            String value = (String)entry.getValue();
            LOGGER.info("{} = {}", (Object)String.format("%" + maxKeyLength + "s", paramName), (Object)value);
        }
    }

    private static class StringTestParameter
    extends TestParameter<String> {
        private StringTestParameter(String key) {
            super(key, null);
        }

        private StringTestParameter(String key, String defaultValue) {
            super(key, defaultValue);
        }

        @Override
        protected String convert(String key) {
            String systemPropertyValue = System.getProperty(key);
            if (systemPropertyValue == null || systemPropertyValue.isEmpty()) {
                return null;
            }
            return systemPropertyValue;
        }
    }

    private static abstract class TestParameter<T> {
        private String key;
        private T defaultValue;

        private TestParameter(String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public T getParameterValue() {
            T parameterValue = this.convert(this.key);
            return parameterValue != null ? parameterValue : this.defaultValue;
        }

        public boolean isParameterConfigured() {
            T parameterValue = this.convert(this.key);
            return parameterValue != null;
        }

        protected abstract T convert(String var1);
    }
}

