/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import io.undertow.Undertow;
import java.util.Arrays;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.kie.server.controller.service.StandaloneKieServerControllerImpl;
import org.kie.server.controller.service.StandaloneSpecManagementServiceImpl;
import org.kie.server.integrationtests.config.TestConfig;

public class KieControllerExecutor {
    protected UndertowJaxrsServer controller;

    public void startKieController() {
        if (this.controller != null) {
            throw new RuntimeException("Kie execution controller is already created!");
        }
        this.controller = new UndertowJaxrsServer();
        this.controller.start(Undertow.builder().addHttpListener(TestConfig.getControllerAllocatedPort().intValue(), "localhost"));
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplication(new Application());
        deployment.setResources(Arrays.asList(new StandaloneSpecManagementServiceImpl(), new StandaloneKieServerControllerImpl()));
        this.controller.deploy(deployment);
    }

    public void stopKieController() {
        if (this.controller == null) {
            throw new RuntimeException("Kie execution controller is already stopped!");
        }
        this.controller.stop();
        this.controller = null;
    }
}

