/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.ProcessExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerDeployer {
    protected static Logger logger = LoggerFactory.getLogger(KieServerDeployer.class);
    private static KieMavenRepository repository;
    private static boolean commonParentDeployed;

    public static void buildAndDeployMavenProjectFromResource(String resourcePath) {
        KieServerDeployer.buildAndDeployMavenProject(KieServerDeployer.class.getResource(resourcePath));
    }

    public static void buildAndDeployMavenProject(URL basedir) {
        logger.debug("Building and deploying Maven project from basedir '{}'.", (Object)basedir);
        String mavenBinary = KieServerDeployer.getMavenBinaryPathFromMavenHomeProperty().orElse("mvn");
        ArrayList<String> mvnArgs = new ArrayList<String>(Collections.singletonList(mavenBinary));
        if (TestConfig.isLocalServer()) {
            mvnArgs.addAll(Arrays.asList("--quiet", "clean", "install"));
        } else {
            mvnArgs.addAll(Arrays.asList("--quiet", "-e", "clean", "deploy"));
        }
        String kjarsBuildSettingsXml = TestConfig.getKjarsBuildSettingsXml();
        if (kjarsBuildSettingsXml != null && !kjarsBuildSettingsXml.isEmpty()) {
            mvnArgs.add("-s");
            mvnArgs.add(kjarsBuildSettingsXml);
        }
        try (ProcessExecutor executor = new ProcessExecutor();){
            String command = mvnArgs.stream().collect(Collectors.joining(" "));
            boolean executionSuccessful = executor.executeProcessCommand(command, Paths.get(basedir.toURI()));
            if (!executionSuccessful) {
                throw new RuntimeException("Error while building Maven project from basedir " + basedir);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot retrieve URI from " + basedir, e);
        }
        logger.debug("Maven project successfully built and deployed!");
    }

    private static Optional<String> getMavenBinaryPathFromMavenHomeProperty() {
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome == null || mavenHome.isEmpty()) {
            return Optional.empty();
        }
        Path mavenBinaryPath = Paths.get(mavenHome, "bin", KieServerDeployer.getMavenBinaryFileName());
        if (mavenBinaryPath.toFile().isFile()) {
            return Optional.of(mavenBinaryPath.toString());
        }
        return Optional.empty();
    }

    private static String getMavenBinaryFileName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "mvn.cmd";
        }
        return "mvn";
    }

    public static void buildAndDeployCommonMavenParent() {
        if (!commonParentDeployed) {
            KieServerDeployer.buildAndDeployMavenProjectFromResource("/kjars-sources/common-parent");
        } else {
            logger.debug("Common parent project already deployed, nothing to do here.");
        }
    }

    public static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServerDeployer.createAndDeployKJar(releaseId, Collections.singletonMap("src/main/resources/org/pkg1/r0.drl", drl));
    }

    public static void createAndDeployKJar(ReleaseId releaseId, Map<String, String> files) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (Map.Entry<String, String> file : files.entrySet()) {
            kfs.write(file.getKey(), file.getValue());
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        KieServerDeployer.getRepository().installArtifact((AFReleaseId)releaseId, jar, pom);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    public static void removeLocalArtifact(ReleaseId releaseId) {
        String originalMavenSettings = System.getProperty("kie.maven.settings.custom");
        String kieServerMavenSettings = TestConfig.getKieServerMavenSettings();
        System.setProperty("kie.maven.settings.custom", kieServerMavenSettings);
        MavenSettings.reinitSettings();
        KieServerDeployer.getRepository().removeLocalArtifact((AFReleaseId)releaseId);
        System.setProperty("kie.maven.settings.custom", originalMavenSettings);
        MavenSettings.reinitSettings();
    }

    public static void cleanAllRepositories() {
        KieServerDeployer.cleanDirectory(TestConfig.getKieServerRemoteRepoDir());
        KieServerDeployer.cleanDirectory(TestConfig.getKieServerLocalRepoDir());
    }

    private static void cleanDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        try {
            FileUtils.deleteDirectory((File)directory);
            directory.mkdir();
        }
        catch (IOException e) {
            logger.error("Cannot delete directory" + directory, (Throwable)e);
        }
    }

    public static MavenRepository getRepository() {
        if (repository == null) {
            KieServices ks = KieServices.Factory.get();
            ReleaseId initReleaseId = new ReleaseId("org.kie.server.initial", "init-maven-repo", "42");
            KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)initReleaseId);
            byte[] pom = kfs.read("pom.xml");
            MavenProject minimalMavenProject = MavenProjectLoader.parseMavenPom((InputStream)new ByteArrayInputStream(pom));
            repository = KieMavenRepository.getKieMavenRepository((MavenProject)minimalMavenProject);
        }
        return repository;
    }

    static {
        commonParentDeployed = false;
    }
}

