/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import javax.ws.rs.core.Response;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.ReaderException;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.client.exception.UnexpectedResponseCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerControllerClient {
    private static Logger logger = LoggerFactory.getLogger(KieServerControllerClient.class);
    private ClientExecutor executor;
    private String controllerBaseUrl;
    private MarshallingFormat format = MarshallingFormat.JAXB;
    private CloseableHttpClient httpClient;
    protected Marshaller marshaller;

    public KieServerControllerClient(String controllerBaseUrl, String login, String password) {
        URL url;
        try {
            url = new URL(controllerBaseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed controller URL was specified: '" + controllerBaseUrl + "'!", e);
        }
        this.controllerBaseUrl = controllerBaseUrl;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (login != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(login, password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        this.httpClient = httpClientBuilder.build();
        this.executor = new ApacheHttpClient4Executor((HttpClient)this.httpClient);
    }

    public KieServerInstance getKieServerInstance(String kieServerInstanceId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId, KieServerInstance.class);
    }

    public KieServerInstance createKieServerInstance(KieServerInfo kieServerInfo) {
        return this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInfo.getServerId(), kieServerInfo, KieServerInstance.class);
    }

    public void deleteKieServerInstance(String kieServerInstanceId) {
        this.makeDeleteRequest(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId);
    }

    public KieServerInstanceList listKieServerInstances() {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/servers", KieServerInstanceList.class);
    }

    public KieContainerResource getContainerInfo(String kieServerInstanceId, String containerId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId, KieContainerResource.class);
    }

    public KieContainerResource createContainer(String kieServerInstanceId, String containerId, KieContainerResource container) {
        return this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId, container, KieContainerResource.class);
    }

    public void disposeContainer(String kieServerInstanceId, String containerId) {
        this.makeDeleteRequest(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId);
    }

    public void startContainer(String kieServerInstanceId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId + "/status/started", "", null);
    }

    public void stopContainer(String kieServerInstanceId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + "/admin/server/" + kieServerInstanceId + "/containers/" + containerId + "/status/stopped", "", null);
    }

    private <T> T makeGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).get(resultType);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private void makeDeleteRequest(String uri) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).delete();
            response.releaseConnection();
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
    }

    private <T> T makePutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).body(this.getMediaType(this.format), (Object)this.serialize(bodyObject)).put(resultType);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private <T> T makePostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).body(this.getMediaType(this.format), bodyObject).post(resultType);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode() || response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(ClientRequest request, ClientResponse<?> response) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unexpected HTTP response code when requesting URI '");
        stringBuffer.append(this.getClientRequestUri(request));
        stringBuffer.append("'! Response code: ");
        stringBuffer.append(response.getStatus());
        try {
            String responseEntity = (String)response.getEntity(String.class);
            stringBuffer.append(" Response message: ");
            stringBuffer.append(responseEntity);
        }
        catch (ReaderException e) {
            response.releaseConnection();
        }
        logger.debug(stringBuffer.toString());
        return new UnexpectedResponseCodeException(response.getStatus(), stringBuffer.toString());
    }

    private RuntimeException createExceptionForUnexpectedFailure(ClientRequest request, Exception e) {
        String summaryMessage = "Unexpected exception when requesting URI '" + this.getClientRequestUri(request) + "'!";
        logger.debug(summaryMessage);
        return new RuntimeException(summaryMessage, e);
    }

    private String getClientRequestUri(ClientRequest clientRequest) {
        String uri;
        try {
            uri = clientRequest.getUri();
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed client URL was specified!", e);
        }
        return uri;
    }

    public void close() {
        try {
            this.executor.close();
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.error("Exception thrown while closing resources!", (Throwable)e);
        }
    }

    public MarshallingFormat getMarshallingFormat() {
        return this.format;
    }

    public void setMarshallingFormat(MarshallingFormat format) {
        this.format = format;
        HashSet<Class<KieServerStatus>> controllerClasses = new HashSet<Class<KieServerStatus>>();
        controllerClasses.add(KieServerInstance.class);
        controllerClasses.add(KieServerInstanceList.class);
        controllerClasses.add(KieServerInstanceInfo.class);
        controllerClasses.add(KieServerSetup.class);
        controllerClasses.add(KieServerStatus.class);
        this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerControllerClient.class.getClassLoader());
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(ClientResponse<T> response, Class<T> type) {
        try {
            if (type == null) {
                T t = null;
                return t;
            }
            String content = (String)response.getEntity(String.class);
            logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
            if (content == null || content.isEmpty()) {
                T t = null;
                return t;
            }
            Object object = this.marshaller.unmarshall(content, type);
            return (T)object;
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while deserializing data received from server!", e);
        }
        finally {
            response.releaseConnection();
        }
    }
}

