/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.ws.rs.core.Response;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.ReaderException;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerKey;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.exception.UnexpectedResponseCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerMgmtControllerClient {
    private static Logger logger = LoggerFactory.getLogger(KieServerMgmtControllerClient.class);
    private static final String MANAGEMENT_LAST_URI_PART = "/management/servers";
    private static final String CONTAINERS_LAST_URI_PART = "/containers";
    private static final String MANAGEMENT_URI_PART = "/management/servers/";
    private static final String CONTAINERS_URI_PART = "/containers/";
    private static final String STARTED_STATUS_URI_PART = "/status/started";
    private static final String STOPPED_STATUS_URI_PART = "/status/stopped";
    private static final String CONFIG_URI_PART = "/config/";
    private ClientExecutor executor;
    private String controllerBaseUrl;
    private MarshallingFormat format = MarshallingFormat.JAXB;
    private CloseableHttpClient httpClient;
    protected Marshaller marshaller;

    public KieServerMgmtControllerClient(String controllerBaseUrl, String login, String password) {
        URL url;
        try {
            url = new URL(controllerBaseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed controller URL was specified: '" + controllerBaseUrl + "'!", e);
        }
        this.controllerBaseUrl = controllerBaseUrl;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (login != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(login, password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        this.httpClient = httpClientBuilder.build();
        this.executor = new ApacheHttpClient4Executor((HttpClient)this.httpClient);
    }

    public ServerTemplate getServerTemplate(String serverTemplateId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId, ServerTemplate.class);
    }

    public void saveContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerSpec.getId(), containerSpec, Object.class);
    }

    public void saveServerTemplate(ServerTemplate serverTemplate) {
        this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplate.getId(), serverTemplate, Object.class);
    }

    public void deleteServerTemplate(String serverTemplateId) {
        this.makeDeleteRequest(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId);
    }

    public ContainerSpec getContainerInfo(String serverTemplateId, String containerId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId, ContainerSpec.class);
    }

    public void deleteContainerSpec(String serverTemplateId, String containerId) {
        this.makeDeleteRequest(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId);
    }

    public Collection<ServerTemplate> listServerTemplates() {
        ServerTemplateList serverTemplateList = this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_LAST_URI_PART, ServerTemplateList.class);
        if (serverTemplateList != null && serverTemplateList.getServerTemplates() != null) {
            return Arrays.asList(serverTemplateList.getServerTemplates());
        }
        return Collections.emptyList();
    }

    public Collection<ContainerSpec> listContainerSpec(String serverTemplateId) {
        ContainerSpecList containerSpecList = this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_LAST_URI_PART, ContainerSpecList.class);
        if (containerSpecList != null && containerSpecList.getContainerSpecs() != null) {
            return Arrays.asList(containerSpecList.getContainerSpecs());
        }
        return Collections.emptyList();
    }

    public void startContainer(String serverTemplateId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + STARTED_STATUS_URI_PART, "", null);
    }

    public void stopContainer(String serverTemplateId, String containerId) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + STOPPED_STATUS_URI_PART, "", null);
    }

    public void updateContainerConfig(String serverTemplateId, String containerId, Capability capability, ContainerConfig config) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + CONFIG_URI_PART + capability.toString(), config, Object.class);
    }

    private <T> T makeGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).get(resultType);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private void makeDeleteRequest(String uri) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).delete();
            response.releaseConnection();
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
    }

    private <T> T makePutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).body(this.getMediaType(this.format), (Object)this.serialize(bodyObject)).put(resultType);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private <T> T makePostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        ClientResponse response;
        ClientRequest clientRequest = new ClientRequest(uri, this.executor);
        try {
            response = clientRequest.accept(this.getMediaType(this.format)).body(this.getMediaType(this.format), bodyObject).post(resultType);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        if (response.getStatus() == Response.Status.CREATED.getStatusCode() || response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response, resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(ClientRequest request, ClientResponse<?> response) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unexpected HTTP response code when requesting URI '");
        stringBuffer.append(this.getClientRequestUri(request));
        stringBuffer.append("'! Response code: ");
        stringBuffer.append(response.getStatus());
        try {
            String responseEntity = (String)response.getEntity(String.class);
            stringBuffer.append(" Response message: ");
            stringBuffer.append(responseEntity);
        }
        catch (ReaderException e) {
            response.releaseConnection();
        }
        logger.debug(stringBuffer.toString());
        return new UnexpectedResponseCodeException(response.getStatus(), stringBuffer.toString());
    }

    private RuntimeException createExceptionForUnexpectedFailure(ClientRequest request, Exception e) {
        String summaryMessage = "Unexpected exception when requesting URI '" + this.getClientRequestUri(request) + "'!";
        logger.debug(summaryMessage);
        return new RuntimeException(summaryMessage, e);
    }

    private String getClientRequestUri(ClientRequest clientRequest) {
        String uri;
        try {
            uri = clientRequest.getUri();
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed client URL was specified!", e);
        }
        return uri;
    }

    public void close() {
        try {
            this.executor.close();
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.error("Exception thrown while closing resources!", (Throwable)e);
        }
    }

    public MarshallingFormat getMarshallingFormat() {
        return this.format;
    }

    public void setMarshallingFormat(MarshallingFormat format) {
        this.format = format;
        HashSet<Class> controllerClasses = new HashSet<Class>();
        controllerClasses.add(KieServerInstance.class);
        controllerClasses.add(KieServerInstanceList.class);
        controllerClasses.add(KieServerInstanceInfo.class);
        controllerClasses.add(KieServerSetup.class);
        controllerClasses.add(KieServerStatus.class);
        controllerClasses.add(ServerInstance.class);
        controllerClasses.add(ServerInstanceKey.class);
        controllerClasses.add(ServerTemplate.class);
        controllerClasses.add(ServerTemplateKey.class);
        controllerClasses.add(ServerConfig.class);
        controllerClasses.add(RuleConfig.class);
        controllerClasses.add(ProcessConfig.class);
        controllerClasses.add(ContainerSpec.class);
        controllerClasses.add(ContainerSpecKey.class);
        controllerClasses.add(Container.class);
        controllerClasses.add(ContainerKey.class);
        controllerClasses.add(ServerTemplateList.class);
        controllerClasses.add(ContainerSpecList.class);
        switch (format) {
            case JAXB: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerMgmtControllerClient.class.getClassLoader());
                break;
            }
            case JSON: {
                this.marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)format, (ClassLoader)KieServerMgmtControllerClient.class.getClassLoader());
                break;
            }
            default: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)KieServerMgmtControllerClient.class.getClassLoader());
            }
        }
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(ClientResponse<T> response, Class<T> type) {
        try {
            Object result;
            if (type == null) {
                T t = null;
                return t;
            }
            String content = (String)response.getEntity(String.class);
            logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
            if (content == null || content.isEmpty()) {
                T t = null;
                return t;
            }
            Object object = result = this.marshaller.unmarshall(content, type);
            return (T)object;
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while deserializing data received from server!", e);
        }
        finally {
            response.releaseConnection();
        }
    }

    public static <T> Class<T> castClass(Class<?> aClass) {
        return aClass;
    }
}

