/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.controller.client.exception.KieServerControllerClientException;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerManagementIntegrationTest;

public class WebSocketKieControllerManagementIntegrationTest
extends KieControllerManagementIntegrationTest<KieServerControllerClientException> {
    @Override
    protected void assertNotFoundException(KieServerControllerClientException e) {
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Override
    protected void assertBadRequestException(KieServerControllerClientException e) {
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Parameterized.Parameters(name="{index}: {0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = WebSocketKieControllerManagementIntegrationTest.createKieServicesRestConfiguration();
        return Arrays.asList(new Object[][]{{MarshallingFormat.JSON, restConfiguration}});
    }

    @Override
    @Before
    public void createControllerClient() {
        this.controllerClient = TestConfig.isLocalServer() ? KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), null, (String)null) : KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }

    @Test
    public void testDeleteServerInstance() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        Assert.assertEquals((long)1L, (long)serverTemplate.getServerInstanceKeys().size());
        ServerInstanceKey serverInstanceKey = new ServerInstanceKey(serverTemplate.getId(), "serverName", "serverInstanceId", "url");
        serverTemplate.addServerInstance(serverInstanceKey);
        Assert.assertEquals((long)2L, (long)serverTemplate.getServerInstanceKeys().size());
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerInstanceKeyList serverInstanceKeyList = this.controllerClient.getServerInstances(serverTemplate.getId());
        Assert.assertEquals((long)2L, (long)serverInstanceKeyList.getServerInstanceKeys().length);
        this.controllerClient.deleteServerInstance(serverInstanceKey);
        serverInstanceKeyList = this.controllerClient.getServerInstances(serverTemplate.getId());
        Assert.assertEquals((long)1L, (long)serverInstanceKeyList.getServerInstanceKeys().length);
    }

    @Test
    public void testDeleteLiveServerInstance() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)serverTemplate.getServerInstanceKeys().iterator().next();
        Assert.assertEquals((long)1L, (long)serverTemplate.getServerInstanceKeys().size());
        try {
            this.controllerClient.deleteServerInstance(serverInstanceKey);
            Assert.fail((String)"Deleting a live server instance should fail");
        }
        catch (KieServerControllerClientException ex) {
            Assert.assertEquals((Object)"Can't delete live instance.", (Object)ex.getMessage());
        }
        ServerInstanceKeyList serverInstanceKeyList = this.controllerClient.getServerInstances(serverTemplate.getId());
        Assert.assertEquals((long)1L, (long)serverInstanceKeyList.getServerInstanceKeys().length);
    }
}

