/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerExecutor;
import org.kie.server.integrationtests.shared.KieServerSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketKieControllerStartupIntegrationTest
extends KieControllerManagementBaseTest {
    public static final Logger logger = LoggerFactory.getLogger(WebSocketKieControllerStartupIntegrationTest.class);
    private String origControllerUrl;
    @Rule
    public TestName testName = new TestName();

    protected KieServicesClient createDefaultClient() {
        KieServicesConfiguration config = KieServicesFactory.newRestConfiguration((String)TestConfig.getEmbeddedKieServerHttpUrl(), null, null);
        config.setMarshallingFormat(this.marshallingFormat);
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
    }

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar");
    }

    @Override
    @Before
    public void setup() throws Exception {
        logger.info("********** Test name " + this.testName.getMethodName() + " ***********");
        if (!TestConfig.isLocalServer()) {
            server = new KieServerExecutor(){

                protected void setKieServerProperties(boolean syncWithController) {
                    super.setKieServerProperties(syncWithController);
                    try {
                        WebSocketKieControllerStartupIntegrationTest.this.origControllerUrl = System.getProperty("org.kie.server.controller");
                        URL controllerUrl = new URL(WebSocketKieControllerStartupIntegrationTest.this.origControllerUrl);
                        String controllerContext = TestConfig.getKieServerControllerContext();
                        String wsControllerUrl = "ws://" + controllerUrl.getHost() + ":" + controllerUrl.getPort() + "/" + controllerContext + "/websocket/controller";
                        System.setProperty("org.kie.server.controller", wsControllerUrl);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Invalid URL for http controller url " + WebSocketKieControllerStartupIntegrationTest.this.origControllerUrl, e);
                    }
                }
            };
            server.startKieServer();
        }
        super.setup();
    }

    @After
    public void cleanupEmbeddedKieServer() {
        try {
            if (TestConfig.isLocalServer()) {
                server.startKieServer();
            } else {
                server.stopKieServer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.origControllerUrl != null) {
            System.setProperty("org.kie.server.controller", this.origControllerUrl);
        }
    }

    @Test
    public void testRegisterKieServerAfterStartup() throws Exception {
        server.stopKieServer();
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)instanceList);
        KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])instanceList.getServerTemplates());
        server.startKieServer();
        KieServerSynchronization.waitForServerTemplateSynchronization((KieServerControllerClient)this.controllerClient, (int)1);
        instanceList = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        ServiceResponse reply = this.client.getServerInfo();
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        Assert.assertNotNull((Object)reply.getResult());
        ServerTemplate deployedServerInstance = instanceList.getServerTemplates()[0];
        Assert.assertNotNull((Object)deployedServerInstance);
        Assert.assertEquals((Object)((KieServerInfo)reply.getResult()).getServerId(), (Object)deployedServerInstance.getId());
    }

    @Test
    public void testTurnOffKieServerAfterShutdown() throws Exception {
        ServiceResponse kieServerInfo = this.client.getServerInfo();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)kieServerInfo.getType());
        Assert.assertNotNull((Object)kieServerInfo.getResult());
        ServerTemplate serverTemplate = new ServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId(), ((KieServerInfo)kieServerInfo.getResult()).getName());
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        Assert.assertEquals((Object)((KieServerInfo)kieServerInfo.getResult()).getServerId(), (Object)instanceList.getServerTemplates()[0].getId());
        server.stopKieServer();
        KieServerSynchronization.waitForServerInstanceSynchronization((KieServerControllerClient)this.controllerClient, (String)serverTemplate.getId(), (int)0);
        instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        Assert.assertEquals((Object)((KieServerInfo)kieServerInfo.getResult()).getServerId(), (Object)instanceList.getServerTemplates()[0].getId());
    }

    @Test
    public void testContainerCreatedAfterStartup() throws Exception {
        ServiceResponse kieServerInfo = this.client.getServerInfo();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)kieServerInfo.getType());
        Assert.assertNotNull((Object)kieServerInfo.getResult());
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        KieServerAssert.assertNullOrEmpty((String)"Active containers found!", (Collection)((KieContainerResourceList)containersList.getResult()).getContainers());
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])instanceList.getServerTemplates());
        server.stopKieServer();
        ServerTemplate serverTemplate = new ServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId(), ((KieServerInfo)kieServerInfo.getResult()).getName());
        this.controllerClient.saveServerTemplate(serverTemplate);
        ContainerSpec containerSpec = new ContainerSpec("kie-concurrent", "kie-concurrent", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ContainerSpec deployedContainer = this.controllerClient.getContainerInfo(((KieServerInfo)kieServerInfo.getResult()).getServerId(), "kie-concurrent");
        Assert.assertNotNull((Object)deployedContainer);
        Assert.assertEquals((Object)"kie-concurrent", (Object)deployedContainer.getId());
        Assert.assertEquals((Object)RELEASE_ID, (Object)deployedContainer.getReleasedId());
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)deployedContainer.getStatus());
        this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
        server.startKieServer(true);
        ServiceResponse containerInfo = this.client.getContainerInfo("kie-concurrent");
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertNotNull((Object)containerInfo.getResult());
        Assert.assertEquals((Object)"kie-concurrent", (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
    }

    @Test
    public void testContainerDisposedAfterStartup() throws Exception {
        ServiceResponse kieServerInfo = this.client.getServerInfo();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)kieServerInfo.getType());
        Assert.assertNotNull((Object)kieServerInfo.getResult());
        ServerTemplate serverTemplate = new ServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId(), ((KieServerInfo)kieServerInfo.getResult()).getName());
        serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)((KieServerInfo)kieServerInfo.getResult()).getLocation()));
        this.controllerClient.saveServerTemplate(serverTemplate);
        ContainerSpec containerSpec = new ContainerSpec("kie-concurrent", "kie-concurrent", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(((KieServerInfo)kieServerInfo.getResult()).getServerId(), containerSpec);
        this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
        try {
            KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        }
        catch (TimeoutException e) {
            this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
            KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        }
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        Assert.assertNotNull((Object)((KieContainerResourceList)containersList.getResult()).getContainers());
        Assert.assertEquals((long)1L, (long)((KieContainerResourceList)containersList.getResult()).getContainers().size());
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        ServerTemplate returnedServerTemplate = this.controllerClient.getServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId());
        logger.info("+++++++++++++++++++++++" + returnedServerTemplate.getServerInstanceKeys());
        server.stopKieServer();
        KieServerSynchronization.waitForServerInstanceSynchronization((KieServerControllerClient)this.controllerClient, (String)((KieServerInfo)kieServerInfo.getResult()).getServerId(), (int)0);
        returnedServerTemplate = this.controllerClient.getServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId());
        logger.info("------------------------" + returnedServerTemplate.getServerInstanceKeys());
        this.controllerClient.stopContainer((ContainerSpecKey)containerSpec);
        this.controllerClient.deleteContainerSpec(serverTemplate.getId(), "kie-concurrent");
        ContainerSpecList containerList = this.controllerClient.listContainerSpec(serverTemplate.getId());
        KieServerAssert.assertNullOrEmpty((String)"Active containers spec found!", (Object[])containerList.getContainerSpecs());
        server.startKieServer(true);
        containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        KieServerAssert.assertNullOrEmpty((String)"Active containers found!", (Collection)((KieContainerResourceList)containersList.getResult()).getContainers());
    }
}

