/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Configuration;
import org.assertj.core.api.SoftAssertions;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.junit.After;
import org.junit.Before;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.RestOnlyBaseIntegrationTest;

public abstract class KieControllerManagementBaseTest
extends RestOnlyBaseIntegrationTest {
    protected static final ReleaseId RELEASE_ID = new ReleaseId("org.kie.server.testing", "stateless-session-kjar", "1.0.0");
    protected static final ReleaseId RELEASE_ID_101 = new ReleaseId("org.kie.server.testing", "stateless-session-kjar", "1.0.1");
    protected static final ReleaseId RELEASE_ID_LATEST = new ReleaseId("org.kie.server.testing", "stateless-session-kjar", "LATEST");
    protected static final String CONTAINER_ID = "kie-concurrent";
    protected static final String CONTAINER_NAME = "containerName";
    protected KieServerControllerClient controllerClient;

    @Before
    public void createControllerClient() {
        Configuration configuration = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(60L, TimeUnit.SECONDS).getConfiguration();
        this.controllerClient = TestConfig.isLocalServer() ? KieServerControllerClientFactory.newRestClient((String)TestConfig.getControllerHttpUrl(), null, null, (MarshallingFormat)this.marshallingFormat, (Configuration)configuration) : KieServerControllerClientFactory.newRestClient((String)TestConfig.getControllerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword(), (MarshallingFormat)this.marshallingFormat, (Configuration)configuration);
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        KieControllerManagementBaseTest.disposeAllContainers();
        this.disposeAllServerInstances();
    }

    @After
    public void closeControllerClient() {
        if (this.controllerClient != null) {
            try {
                logger.info("Closing Kie Server Management Controller client");
                this.controllerClient.close();
            }
            catch (IOException e) {
                logger.error("Error trying to close Kie Server Management Controller Client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected ServerTemplate createServerTemplate(String id, String name) {
        return this.createServerTemplate(id, name, null, null, null);
    }

    protected ServerTemplate createServerTemplate(String id, String name, String location) {
        return this.createServerTemplate(id, name, location, null, null);
    }

    protected ServerTemplate createServerTemplate(String id, String name, String location, KieServerMode mode, List<String> capabilities) {
        ServerTemplate serverTemplate = KieControllerManagementBaseTest.buildServerTemplate(id, name, location, null, null);
        this.controllerClient.saveServerTemplate(serverTemplate);
        return serverTemplate;
    }

    protected static ServerTemplate buildServerTemplate(String id, String name, String location, KieServerMode mode, List<String> capabilities) {
        ServerTemplate serverTemplate = new ServerTemplate(id, name);
        if (mode != null) {
            serverTemplate.setMode(mode);
        }
        if (capabilities != null && !capabilities.isEmpty()) {
            serverTemplate.setCapabilities(capabilities);
        }
        if (location != null) {
            serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)location));
        }
        return serverTemplate;
    }

    protected ContainerSpec createContainerSpec(ServerTemplate serverTemplate, ReleaseId releaseId, KieContainerStatus status) {
        ContainerSpec containerSpec = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, releaseId, status, Collections.emptyMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        return containerSpec;
    }

    protected void checkContainer(ContainerSpec container, KieContainerStatus status) {
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)container).isNotNull();
            softly.assertThat(container.getId()).isEqualTo(CONTAINER_ID);
            softly.assertThat((Comparable)container.getReleasedId()).isEqualTo((Object)RELEASE_ID);
            softly.assertThat((Comparable)container.getStatus()).isEqualTo((Object)status);
        });
    }
}

