/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.integrationtests.category.UnstableOnJenkinsPrBuilder;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerExecutor;
import org.kie.server.integrationtests.shared.KieServerSynchronization;

public class KieControllerStartupIntegrationTest
extends KieControllerManagementBaseTest {
    protected KieServicesClient createDefaultClient() {
        KieServicesConfiguration config = KieServicesFactory.newRestConfiguration((String)TestConfig.getEmbeddedKieServerHttpUrl(), null, null);
        config.setMarshallingFormat(this.marshallingFormat);
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
    }

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar");
    }

    @Override
    @Before
    public void setup() throws Exception {
        if (!TestConfig.isLocalServer()) {
            server = new KieServerExecutor();
            server.startKieServer();
        }
        super.setup();
    }

    @After
    public void cleanupEmbeddedKieServer() {
        try {
            if (TestConfig.isLocalServer()) {
                server.startKieServer();
            } else {
                server.stopKieServer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterKieServerAfterStartup() {
        server.stopKieServer();
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)instanceList);
        KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])instanceList.getServerTemplates());
        server.startKieServer();
        instanceList = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        ServiceResponse reply = this.client.getServerInfo();
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        Assert.assertNotNull((Object)reply.getResult());
        ServerTemplate deployedServerInstance = instanceList.getServerTemplates()[0];
        Assert.assertNotNull((Object)deployedServerInstance);
        Assert.assertEquals((Object)((KieServerInfo)reply.getResult()).getServerId(), (Object)deployedServerInstance.getId());
    }

    @Test
    public void testTurnOffKieServerAfterShutdown() {
        ServiceResponse kieServerInfo = this.client.getServerInfo();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)kieServerInfo.getType());
        Assert.assertNotNull((Object)kieServerInfo.getResult());
        ServerTemplate serverTemplate = new ServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId(), ((KieServerInfo)kieServerInfo.getResult()).getName());
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        Assert.assertEquals((Object)((KieServerInfo)kieServerInfo.getResult()).getServerId(), (Object)instanceList.getServerTemplates()[0].getId());
        server.stopKieServer();
        instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        Assert.assertEquals((Object)((KieServerInfo)kieServerInfo.getResult()).getServerId(), (Object)instanceList.getServerTemplates()[0].getId());
    }

    @Test
    public void testContainerCreatedAfterStartup() throws Exception {
        ServiceResponse kieServerInfo = this.client.getServerInfo();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)kieServerInfo.getType());
        Assert.assertNotNull((Object)kieServerInfo.getResult());
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        KieServerAssert.assertNullOrEmpty((String)"Active containers found!", (Collection)((KieContainerResourceList)containersList.getResult()).getContainers());
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])instanceList.getServerTemplates());
        server.stopKieServer();
        ServerTemplate serverTemplate = new ServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId(), ((KieServerInfo)kieServerInfo.getResult()).getName());
        this.controllerClient.saveServerTemplate(serverTemplate);
        ContainerSpec containerSpec = new ContainerSpec("kie-concurrent", "kie-concurrent", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ContainerSpec deployedContainer = this.controllerClient.getContainerInfo(((KieServerInfo)kieServerInfo.getResult()).getServerId(), "kie-concurrent");
        Assert.assertNotNull((Object)deployedContainer);
        Assert.assertEquals((Object)"kie-concurrent", (Object)deployedContainer.getId());
        Assert.assertEquals((Object)RELEASE_ID, (Object)deployedContainer.getReleasedId());
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)deployedContainer.getStatus());
        this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
        server.startKieServer();
        ServiceResponse containerInfo = this.client.getContainerInfo("kie-concurrent");
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertNotNull((Object)containerInfo.getResult());
        Assert.assertEquals((Object)"kie-concurrent", (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
    }

    @Test
    @Category(value={UnstableOnJenkinsPrBuilder.class})
    public void testContainerDisposedAfterStartup() throws Exception {
        ServiceResponse kieServerInfo = this.client.getServerInfo();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)kieServerInfo.getType());
        Assert.assertNotNull((Object)kieServerInfo.getResult());
        ServerTemplate serverTemplate = new ServerTemplate(((KieServerInfo)kieServerInfo.getResult()).getServerId(), ((KieServerInfo)kieServerInfo.getResult()).getName());
        serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)((KieServerInfo)kieServerInfo.getResult()).getLocation()));
        this.controllerClient.saveServerTemplate(serverTemplate);
        ContainerSpec containerSpec = new ContainerSpec("kie-concurrent", "kie-concurrent", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(((KieServerInfo)kieServerInfo.getResult()).getServerId(), containerSpec);
        this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
        try {
            KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        }
        catch (TimeoutException e) {
            this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
            KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        }
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        Assert.assertNotNull((Object)((KieContainerResourceList)containersList.getResult()).getContainers());
        Assert.assertEquals((long)1L, (long)((KieContainerResourceList)containersList.getResult()).getContainers().size());
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        server.stopKieServer();
        this.controllerClient.stopContainer((ContainerSpecKey)containerSpec);
        this.controllerClient.deleteContainerSpec(serverTemplate.getId(), "kie-concurrent");
        server.startKieServer();
        containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        KieServerAssert.assertNullOrEmpty((String)"Active containers found!", (Collection)((KieContainerResourceList)containersList.getResult()).getContainers());
    }
}

