/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.exception.KieServerControllerClientException;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.kie.server.integrationtests.category.Smoke;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerSynchronization;

public abstract class KieControllerManagementIntegrationTest<T extends KieServerControllerClientException>
extends KieControllerManagementBaseTest {
    protected static final String CONTAINER_ID = "kie-concurrent";
    protected static final String CONTAINER_NAME = "containerName";
    protected KieServerInfo kieServerInfo;

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.createAndDeployKJar((ReleaseId)RELEASE_ID);
        KieServerDeployer.createAndDeployKJar((ReleaseId)RELEASE_ID_101);
    }

    @Before
    public void getKieServerInfo() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
        ServiceResponse reply = this.client.getServerInfo();
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        this.kieServerInfo = (KieServerInfo)reply.getResult();
    }

    protected abstract void assertNotFoundException(T var1);

    protected abstract void assertBadRequestException(T var1);

    protected void checkServerTemplate(ServerTemplate actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)this.kieServerInfo.getServerId(), (Object)actual.getId());
        Assert.assertEquals((Object)this.kieServerInfo.getName(), (Object)actual.getName());
    }

    protected ServerTemplate createServerTemplate() {
        return this.createServerTemplate(this.kieServerInfo.getServerId(), this.kieServerInfo.getName(), this.kieServerInfo.getLocation());
    }

    protected void checkContainerConfig(String serverTemplateId, String containerId, ContainerConfig ... configs) {
        Map configMap = this.controllerClient.getContainerInfo(serverTemplateId, containerId).getConfigs();
        Assert.assertNotNull((Object)configMap);
        for (ContainerConfig config : configs) {
            if (config instanceof ProcessConfig) {
                ProcessConfig pc = (ProcessConfig)config;
                ProcessConfig processConfig = (ProcessConfig)configMap.get(Capability.PROCESS);
                Assert.assertNotNull((Object)processConfig);
                Assert.assertEquals((Object)pc.getKBase(), (Object)processConfig.getKBase());
                Assert.assertEquals((Object)pc.getKSession(), (Object)processConfig.getKSession());
                Assert.assertEquals((Object)pc.getMergeMode(), (Object)processConfig.getMergeMode());
                Assert.assertEquals((Object)pc.getRuntimeStrategy(), (Object)processConfig.getRuntimeStrategy());
                continue;
            }
            if (!(config instanceof RuleConfig)) continue;
            RuleConfig rc = (RuleConfig)config;
            RuleConfig ruleConfig = (RuleConfig)configMap.get(Capability.RULE);
            Assert.assertNotNull((Object)ruleConfig);
            Assert.assertEquals((Object)rc.getPollInterval(), (Object)ruleConfig.getPollInterval());
            Assert.assertEquals((Object)rc.getScannerStatus(), (Object)ruleConfig.getScannerStatus());
        }
    }

    @Test
    public void testDeleteNotExistingServerTemplate() {
        try {
            this.controllerClient.deleteServerTemplate("not-existing");
            Assert.fail((String)"Should throw exception about server template not existing.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)"No server template found for id not-existing");
        }
    }

    @Test
    @Category(value={Smoke.class})
    public void testCreateKieServerTemplate() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ServerTemplate storedServerTemplate = this.controllerClient.getServerTemplate(serverTemplate.getId());
        this.checkServerTemplate(storedServerTemplate);
        ServerTemplateList serverTemplates = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)serverTemplates);
        Assert.assertEquals((long)1L, (long)serverTemplates.getServerTemplates().length);
        storedServerTemplate = serverTemplates.getServerTemplates()[0];
        this.checkServerTemplate(storedServerTemplate);
    }

    @Test
    public void testCreateDuplicateServerTemplate() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerTemplateList serverTemplates = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)serverTemplates);
        Assert.assertEquals((long)1L, (long)serverTemplates.getServerTemplates().length);
    }

    @Test
    public void testDeleteServerTemplate() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ServerTemplateList serverTemplates = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)serverTemplates);
        Assert.assertEquals((long)1L, (long)serverTemplates.getServerTemplates().length);
        this.controllerClient.deleteServerTemplate(serverTemplate.getId());
        serverTemplates = this.controllerClient.listServerTemplates();
        KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])serverTemplates.getServerTemplates());
    }

    @Test
    @Category(value={Smoke.class})
    public void testGetKieServerInstance() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)serverTemplate.getServerInstanceKeys().iterator().next();
        ServerTemplate serverInstance = this.controllerClient.getServerTemplate(serverTemplate.getId());
        this.checkServerTemplate(serverInstance);
        Assert.assertNotNull((String)"Kie server instance isn't managed!", (Object)serverInstance.getServerInstanceKeys());
        Assert.assertEquals((long)1L, (long)serverInstance.getServerInstanceKeys().size());
        ServerInstanceKey managedInstance = (ServerInstanceKey)serverInstance.getServerInstanceKeys().iterator().next();
        Assert.assertNotNull((Object)managedInstance);
        Assert.assertEquals((Object)this.kieServerInfo.getLocation(), (Object)managedInstance.getUrl());
        Assert.assertEquals((Object)serverTemplate.getId(), (Object)managedInstance.getServerTemplateId());
        Assert.assertEquals((Object)serverInstanceKey.getServerName(), (Object)managedInstance.getServerName());
    }

    @Test
    public void testGetNotExistingServerTemplate() {
        try {
            this.controllerClient.getServerTemplate(this.kieServerInfo.getServerId());
            Assert.fail((String)"Should throw exception about kie server instance not existing.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
    }

    @Test
    public void testListKieServerInstances() {
        this.createServerTemplate();
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        ServerTemplate serverInstance = instanceList.getServerTemplates()[0];
        this.checkServerTemplate(serverInstance);
        Assert.assertNotNull((String)"Kie server instance isn't managed!", (Object)serverInstance.getServerInstanceKeys());
        Assert.assertEquals((long)1L, (long)serverInstance.getServerInstanceKeys().size());
        ServerInstanceKey managedInstance = (ServerInstanceKey)serverInstance.getServerInstanceKeys().iterator().next();
        Assert.assertNotNull((Object)managedInstance);
        Assert.assertEquals((Object)this.kieServerInfo.getLocation(), (Object)managedInstance.getUrl());
    }

    @Test
    public void testEmptyListServerTemplates() throws Exception {
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        KieServerAssert.assertNullOrEmpty((String)"Server templates found!", (Object[])instanceList.getServerTemplates());
    }

    @Test
    public void testContainerHandling() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        KieServerAssert.assertNullOrEmpty((String)"Active containers found!", (Collection)((KieContainerResourceList)containersList.getResult()).getContainers());
        this.controllerClient.deleteContainerSpec(serverTemplate.getId(), CONTAINER_ID);
        try {
            this.controllerClient.getContainerInfo(serverTemplate.getId(), CONTAINER_ID);
            Assert.fail((String)"Should throw exception about container info not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("Server template " + serverTemplate.getId() + " does not have container with id " + CONTAINER_ID));
        }
    }

    @Test
    public void testCreateContainerAutoStart() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        Assert.assertEquals((long)1L, (long)((KieContainerResourceList)containersList.getResult()).getContainers().size());
        ServiceResponse containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)CONTAINER_ID, (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)((KieContainerResource)containerInfo.getResult()).getReleaseId());
    }

    @Test
    public void testCreateServerTemplateWithContainersAutoStart() throws Exception {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setId(this.kieServerInfo.getServerId());
        serverTemplate.setName(this.kieServerInfo.getName());
        serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)this.kieServerInfo.getLocation()));
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()), RELEASE_ID, KieContainerStatus.STARTED, new HashMap());
        serverTemplate.addContainerSpec(containerToDeploy);
        this.controllerClient.saveServerTemplate(serverTemplate);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        ServiceResponse containersList = this.client.listContainers();
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersList.getType());
        Assert.assertEquals((long)1L, (long)((KieContainerResourceList)containersList.getResult()).getContainers().size());
        ServiceResponse containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)CONTAINER_ID, (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)((KieContainerResource)containerInfo.getResult()).getReleaseId());
    }

    @Test
    public void testGetContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
    }

    @Test
    public void testGetAndUpdateContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
        containerToDeploy.setReleasedId(RELEASE_ID_101);
        this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        Assert.assertNotNull((Object)containerResponseEntity);
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerResponseEntity.getId());
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)containerResponseEntity.getStatus());
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)RELEASE_ID_101, (Object)containerResponseEntity.getReleasedId());
    }

    @Test
    public void testStartAndStopContainer() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        ServiceResponse containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)containerInfo.getType());
        KieServerAssert.assertResultContainsString((String)containerInfo.getMsg(), (String)"Container kie-concurrent is not instantiated.");
        this.controllerClient.startContainer((ContainerSpecKey)containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)CONTAINER_ID, (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)((KieContainerResource)containerInfo.getResult()).getReleaseId());
        this.controllerClient.stopContainer((ContainerSpecKey)containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)0);
        containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)containerInfo.getType());
        KieServerAssert.assertResultContainsString((String)containerInfo.getMsg(), (String)"Container kie-concurrent is not instantiated.");
    }

    @Test
    public void testGetNotExistingContainer() {
        try {
            this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
            Assert.fail((String)"Should throw exception about container info not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
        this.createServerTemplate();
        try {
            this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
            Assert.fail((String)"Should throw exception about container info not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("Server template " + this.kieServerInfo.getServerId() + " does not have container with id " + CONTAINER_ID));
        }
    }

    @Test
    public void testListContainers() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpecList containerList = this.controllerClient.listContainerSpec(this.kieServerInfo.getServerId());
        Assert.assertNotNull((Object)containerList);
        Assert.assertEquals((long)1L, (long)containerList.getContainerSpecs().length);
        ContainerSpec containerResponseEntity = containerList.getContainerSpecs()[0];
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
    }

    @Test
    public void testUpdateContainerConfig() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        HashMap<Capability, Object> containerConfigMap = new HashMap<Capability, Object>();
        ProcessConfig processConfig = new ProcessConfig("PER_PROCESS_INSTANCE", "kieBase", "kieSession", "MERGE_COLLECTION");
        containerConfigMap.put(Capability.PROCESS, processConfig);
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(500L), KieScannerStatus.SCANNING);
        containerConfigMap.put(Capability.RULE, ruleConfig);
        ContainerSpec containerSpec = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, containerConfigMap);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        this.checkContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, new ContainerConfig[]{processConfig, ruleConfig});
        processConfig = new ProcessConfig("SINGLETON", "defaultKieBase", "defaultKieSession", "OVERRIDE_ALL");
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.PROCESS, (ContainerConfig)processConfig);
        this.checkContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, new ContainerConfig[]{processConfig, ruleConfig});
        ruleConfig = new RuleConfig(Long.valueOf(1000L), KieScannerStatus.STOPPED);
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.RULE, (ContainerConfig)ruleConfig);
        this.checkContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, new ContainerConfig[]{processConfig, ruleConfig});
    }

    @Test
    public void testCreateContainerOnNotExistingKieServerInstance() {
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)new ServerTemplate(), RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        try {
            this.controllerClient.saveContainerSpec(this.kieServerInfo.getServerId(), containerToDeploy);
            Assert.fail((String)"Should throw exception about server template not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
    }

    @Test
    public void testCreateDuplicitContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        try {
            this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
            Assert.fail((String)"Should throw exception about container being created already.");
        }
        catch (KieServerControllerClientException e) {
            this.assertBadRequestException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("Server template with id " + serverTemplate.getId() + " associated already with container " + CONTAINER_ID));
        }
    }

    @Test
    public void testDeleteNotExistingContainer() {
        try {
            this.controllerClient.deleteContainerSpec(this.kieServerInfo.getServerId(), CONTAINER_ID);
            Assert.fail((String)"Should throw exception about kie server instance not exists.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
        this.createServerTemplate();
        try {
            this.controllerClient.deleteContainerSpec(this.kieServerInfo.getServerId(), CONTAINER_ID);
            Assert.fail((String)"Should throw exception about container not exists.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)"Container kie-concurrent not found");
        }
    }

    @Test
    public void testStartNotExistingContainer() throws Exception {
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId(CONTAINER_ID);
        containerSpec.setServerTemplateKey(new ServerTemplateKey(this.kieServerInfo.getServerId(), null));
        try {
            this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
            Assert.fail((String)"Should throw exception about server template not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
        this.createServerTemplate();
        try {
            this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
            Assert.fail((String)"Should throw exception about container not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No container spec found for id kie-concurrent within server template with id " + this.kieServerInfo.getServerId()));
        }
    }

    @Test
    public void testStopNotExistingContainer() throws Exception {
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId(CONTAINER_ID);
        containerSpec.setServerTemplateKey(new ServerTemplateKey(this.kieServerInfo.getServerId(), null));
        try {
            this.controllerClient.stopContainer((ContainerSpecKey)containerSpec);
            Assert.fail((String)"Should throw exception about server template not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
        this.createServerTemplate();
        try {
            this.controllerClient.stopContainer((ContainerSpecKey)containerSpec);
            Assert.fail((String)"Should throw exception about container not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No container spec found for id kie-concurrent within server template with id " + this.kieServerInfo.getServerId()));
        }
    }

    @Test
    public void testEmptyListContainers() {
        try {
            this.controllerClient.listContainerSpec(this.kieServerInfo.getServerId());
            Assert.fail((String)"Should throw exception about server template not existing.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
        this.createServerTemplate();
        ContainerSpecList emptyList = this.controllerClient.listContainerSpec(this.kieServerInfo.getServerId());
        KieServerAssert.assertNullOrEmpty((String)"Active containers found!", (Object[])emptyList.getContainerSpecs());
    }

    @Test
    public void testUpdateContainerConfigOnNotExistingContainer() {
        ProcessConfig config = new ProcessConfig("PER_PROCESS_INSTANCE", "kieBase", "kieSession", "MERGE_COLLECTION");
        try {
            this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.PROCESS, (ContainerConfig)config);
            Assert.fail((String)"Should throw exception about server template not existing.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No server template found for id " + this.kieServerInfo.getServerId()));
        }
        this.createServerTemplate();
        try {
            this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.PROCESS, (ContainerConfig)config);
            Assert.fail((String)"Should throw exception about container info not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("No container spec found for id kie-concurrent within server template with id " + this.kieServerInfo.getServerId()));
        }
    }

    @Test
    public void testTemplateKeyChangeDuringUpdate() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, Collections.EMPTY_MAP);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
        ServerTemplate secondTemplate = this.createServerTemplate("st-id", "st-id", this.kieServerInfo.getLocation());
        containerToDeploy.setServerTemplateKey((ServerTemplateKey)secondTemplate);
        try {
            this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerToDeploy);
            Assert.fail((String)"Template key should not be allowed to be changed during update.");
        }
        catch (KieServerControllerClientException e) {
            this.assertBadRequestException(e);
            KieServerAssert.assertResultContainsString((String)e.getMessage(), (String)"Cannot change container template key during update.");
        }
        Assert.assertEquals((long)2L, (long)this.controllerClient.listServerTemplates().getServerTemplates().length);
        KieServerAssert.assertNullOrEmpty((String)"Found container in second server template.", (Object[])this.controllerClient.listContainerSpec(secondTemplate.getId()).getContainerSpecs());
        Assert.assertEquals((long)1L, (long)this.controllerClient.listContainerSpec(serverTemplate.getId()).getContainerSpecs().length);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)serverTemplate.getId(), (Object)containerResponseEntity.getServerTemplateKey().getId());
        Assert.assertEquals((Object)serverTemplate.getName(), (Object)containerResponseEntity.getServerTemplateKey().getName());
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
    }

    @Test
    public void testUpdateContainerWithDifferrentID() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        String ONE_ID = "one";
        String TWO_ID = "two";
        ContainerSpec containerOneToDeploy = new ContainerSpec("one", "one", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, Collections.EMPTY_MAP);
        ContainerSpec containerTwoToDeploy = new ContainerSpec("two", "two", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, Collections.EMPTY_MAP);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerOneToDeploy);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerTwoToDeploy);
        containerOneToDeploy.setReleasedId(RELEASE_ID_101);
        try {
            this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerTwoToDeploy.getId(), containerOneToDeploy);
            Assert.fail((String)"Container one was updated from container two REST endpoint.");
        }
        catch (KieServerControllerClientException e) {
            this.assertBadRequestException(e);
            KieServerAssert.assertResultContainsString((String)e.getMessage(), (String)("Cannot update container " + containerOneToDeploy.getId() + " on container " + containerTwoToDeploy.getId()));
        }
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(serverTemplate.getId(), "one");
        Assert.assertEquals((Object)"one", (Object)containerResponseEntity.getId());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)containerResponseEntity.getStatus());
        containerResponseEntity = this.controllerClient.getContainerInfo(serverTemplate.getId(), "two");
        Assert.assertEquals((Object)"two", (Object)containerResponseEntity.getId());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)containerResponseEntity.getStatus());
    }

    @Test
    public void testCreateContainerByUpdateContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, Collections.EMPTY_MAP);
        try {
            this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerToDeploy);
            Assert.fail((String)"Container was created by update command - REST Post method.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
        }
        KieServerAssert.assertNullOrEmpty((String)"Found deployed container.", (Object[])this.controllerClient.listContainerSpec(serverTemplate.getId()).getContainerSpecs());
    }

    @Test
    public void testUpdateContainerId() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, Collections.EMPTY_MAP);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        containerToDeploy.setId("newID");
        try {
            this.controllerClient.updateContainerSpec(serverTemplate.getId(), CONTAINER_ID, containerToDeploy);
            Assert.fail((String)"Container has updated id.");
        }
        catch (KieServerControllerClientException e) {
            this.assertBadRequestException(e);
            KieServerAssert.assertResultContainsString((String)e.getMessage(), (String)"Cannot update container newID on container kie-concurrent");
        }
    }

    @Test
    public void testUpdateNotExistingContainerConfig() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerSpec = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        KieServerAssert.assertNullOrEmpty((String)"Config is not empty.", containerResponseEntity.getConfigs().values());
        ProcessConfig processConfig = new ProcessConfig("PER_PROCESS_INSTANCE", "kieBase", "kieSession", "MERGE_COLLECTION");
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.PROCESS, (ContainerConfig)processConfig);
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(500L), KieScannerStatus.SCANNING);
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.RULE, (ContainerConfig)ruleConfig);
    }

    @Test
    public void testUpdateContainerNonValidReleaseId() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, Collections.EMPTY_MAP);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        ServiceResponse containerInfoResponse = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfoResponse.getType());
        KieContainerResource containerResource = (KieContainerResource)containerInfoResponse.getResult();
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerResource.getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)containerResource.getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResource.getReleaseId());
        ReleaseId nonValidReleaseId = new ReleaseId("org.kie.server.testing", "stateless-session-kjar", "2.0.0");
        containerToDeploy.setReleasedId(nonValidReleaseId);
        this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerResponseEntity.getId());
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)containerResponseEntity.getStatus());
        Assert.assertEquals((Object)nonValidReleaseId, (Object)containerResponseEntity.getReleasedId());
        String updateErrorMessage = "Error updating releaseId for container kie-concurrent to version " + nonValidReleaseId.toString();
        KieServerSynchronization.waitForKieServerMessage((KieServicesClient)this.client, (String)CONTAINER_ID, (String)updateErrorMessage);
        containerInfoResponse = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfoResponse.getType());
        containerResource = (KieContainerResource)containerInfoResponse.getResult();
        Assert.assertEquals((long)1L, (long)containerResource.getMessages().size());
        Collection messages = ((Message)containerResource.getMessages().get(0)).getMessages();
        Assert.assertEquals((long)2L, (long)messages.size());
        Assertions.assertThat((Iterable)messages).contains((Object[])new String[]{updateErrorMessage});
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerResource.getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)containerResource.getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResource.getReleaseId());
    }

    @Test
    public void testStartContainerByUpdateKieContainerStatus() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, Collections.EMPTY_MAP);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        ServiceResponse containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)containerInfo.getType());
        KieServerAssert.assertResultContainsString((String)containerInfo.getMsg(), (String)"Container kie-concurrent is not instantiated.");
        containerToDeploy.setStatus(KieContainerStatus.STARTED);
        this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)CONTAINER_ID, (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)((KieContainerResource)containerInfo.getResult()).getReleaseId());
    }

    @Test
    public void testUpdateContainerWitoutContainerConfig() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        HashMap<Capability, Object> containerConfigMap = new HashMap<Capability, Object>();
        ProcessConfig processConfig = new ProcessConfig("PER_PROCESS_INSTANCE", "kieBase", "kieSession", "MERGE_COLLECTION");
        containerConfigMap.put(Capability.PROCESS, processConfig);
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(5000L), KieScannerStatus.SCANNING);
        containerConfigMap.put(Capability.RULE, ruleConfig);
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, containerConfigMap);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
        this.checkContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, new ContainerConfig[]{processConfig, ruleConfig});
        containerToDeploy.setConfigs(Collections.EMPTY_MAP);
        this.controllerClient.updateContainerSpec(serverTemplate.getId(), containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        Assert.assertEquals((Object)CONTAINER_NAME, (Object)containerResponseEntity.getContainerName());
        Assert.assertEquals((Object)RELEASE_ID, (Object)containerResponseEntity.getReleasedId());
        KieServerAssert.assertNullOrEmpty((String)"Container configuration was found.", containerResponseEntity.getConfigs().keySet());
    }

    @Test
    public void testUpdateContainerConfigSent() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        HashMap<Capability, Object> containerConfigMap = new HashMap<Capability, Object>();
        ProcessConfig processConfig = new ProcessConfig("PER_PROCESS_INSTANCE", "kieBase", "kieSession", "MERGE_COLLECTION");
        containerConfigMap.put(Capability.PROCESS, processConfig);
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(500L), KieScannerStatus.STARTED);
        containerConfigMap.put(Capability.RULE, ruleConfig);
        ContainerSpec containerSpec = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, containerConfigMap);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        this.checkContainerConfigAgainstServer(new ContainerConfig[]{processConfig, ruleConfig});
        ruleConfig.setScannerStatus(KieScannerStatus.STOPPED);
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.RULE, (ContainerConfig)ruleConfig);
        KieServerSynchronization.waitForKieServerScannerStatus((KieServicesClient)this.client, (String)CONTAINER_ID, (KieScannerStatus)KieScannerStatus.STOPPED);
        this.checkContainerConfigAgainstServer(new ContainerConfig[]{ruleConfig});
        processConfig = new ProcessConfig("SINGLETON", "defaultKieBase", "defaultKieSession", "OVERRIDE_ALL");
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.PROCESS, (ContainerConfig)processConfig);
        this.controllerClient.stopContainer((ContainerSpecKey)containerSpec);
        this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
        KieServerSynchronization.waitForKieServerConfig((KieServicesClient)this.client, (String)CONTAINER_ID, (String)"MergeMode", (String)"OVERRIDE_ALL");
        this.checkContainerConfigAgainstServer(new ContainerConfig[]{processConfig});
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        this.controllerClient.updateContainerConfig(this.kieServerInfo.getServerId(), CONTAINER_ID, Capability.RULE, (ContainerConfig)ruleConfig);
        KieServerSynchronization.waitForKieServerScannerStatus((KieServicesClient)this.client, (String)CONTAINER_ID, (KieScannerStatus)KieScannerStatus.STARTED, (Long)1000L);
        this.checkContainerConfigAgainstServer(new ContainerConfig[]{ruleConfig, processConfig});
    }

    @Test
    public void testDeleteContainerStopsContainer() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        HashMap containerConfigMap = new HashMap();
        ContainerSpec containerSpec = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, containerConfigMap);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerSpec);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        ServiceResponse response = this.client.getServerState();
        KieServerAssert.assertSuccess((ServiceResponse)response);
        KieServerStateInfo serverState = (KieServerStateInfo)response.getResult();
        Assert.assertNotNull((Object)serverState);
        Assert.assertTrue((String)"Expected to find containers, but none were found", (serverState.getContainers() != null && serverState.getContainers().size() > 0 ? 1 : 0) != 0);
        this.controllerClient.deleteContainerSpec(serverTemplate.getId(), CONTAINER_ID);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)0);
        response = this.client.getServerState();
        serverState = (KieServerStateInfo)response.getResult();
        Assert.assertNotNull((Object)serverState);
        Assert.assertFalse((String)"Did not expect to find containers", (serverState.getContainers() != null && serverState.getContainers().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testActivateAndDeactivateContainer() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerToDeploy = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STOPPED, new HashMap());
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        ContainerSpec containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STOPPED);
        ServiceResponse containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)containerInfo.getType());
        KieServerAssert.assertResultContainsString((String)containerInfo.getMsg(), (String)"Container kie-concurrent is not instantiated.");
        this.controllerClient.startContainer((ContainerSpecKey)containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)CONTAINER_ID, (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((Object)RELEASE_ID, (Object)((KieContainerResource)containerInfo.getResult()).getReleaseId());
        this.controllerClient.deactivateContainer((ContainerSpecKey)containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.DEACTIVATED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)KieContainerStatus.DEACTIVATED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        this.controllerClient.activateContainer((ContainerSpecKey)containerToDeploy);
        containerResponseEntity = this.controllerClient.getContainerInfo(this.kieServerInfo.getServerId(), CONTAINER_ID);
        this.checkContainer(containerResponseEntity, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        containerInfo = this.client.getContainerInfo(CONTAINER_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
    }

    protected void checkContainerConfigAgainstServer(ContainerConfig ... configs) {
        ServiceResponse containerResource = this.client.getContainerInfo(CONTAINER_ID);
        KieServerAssert.assertSuccess((ServiceResponse)containerResource);
        KieContainerResource kcr = (KieContainerResource)containerResource.getResult();
        Assert.assertNotNull((Object)kcr);
        for (ContainerConfig config : configs) {
            if (config instanceof ProcessConfig) {
                ProcessConfig pc = (ProcessConfig)config;
                HashMap<String, String> configMap = new HashMap<String, String>();
                configMap.put("KBase", pc.getKBase());
                configMap.put("KSession", pc.getKSession());
                configMap.put("MergeMode", pc.getMergeMode());
                configMap.put("RuntimeStrategy", pc.getRuntimeStrategy());
                Assert.assertNotNull((String)"No configuration items found for checking process configuration", (Object)kcr.getConfigItems());
                List kci = kcr.getConfigItems();
                for (KieServerConfigItem item : kci) {
                    String name = item.getName();
                    String value = item.getValue();
                    Assert.assertEquals(configMap.get(name), (Object)value);
                }
                continue;
            }
            if (!(config instanceof RuleConfig)) continue;
            RuleConfig rc = (RuleConfig)config;
            KieScannerResource scanner = kcr.getScanner();
            Assert.assertNotNull((String)"No scanner resource found", (Object)scanner);
            Assert.assertEquals((Object)rc.getScannerStatus(), (Object)scanner.getStatus());
            if (rc.getScannerStatus() != KieScannerStatus.STARTED) continue;
            Assert.assertEquals((Object)rc.getPollInterval(), (Object)scanner.getPollInterval());
        }
    }
}

