/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.client.exception.KieServerControllerClientException;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.kie.server.integrationtests.category.UnstableOnJenkinsPrBuilder;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerSynchronization;

public abstract class KieControllerRuleCapabilitiesIntegrationTest<T extends KieServerControllerClientException>
extends KieControllerManagementBaseTest {
    private KieServerInfo kieServerInfo;

    @Before
    public void initializeRemoteRepo() throws Exception {
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar");
    }

    protected abstract void assertNotFoundException(T var1);

    protected abstract void assertBadRequestException(T var1);

    @Before
    public void getKieServerInfo() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
        ServiceResponse reply = this.client.getServerInfo();
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        this.kieServerInfo = (KieServerInfo)reply.getResult();
    }

    @After
    public void cleanAllRepos() throws IOException {
        KieServerDeployer.cleanAllRepositories();
    }

    @Test
    @Category(value={UnstableOnJenkinsPrBuilder.class})
    public void testScanNow() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = this.createContainerSpec(serverTemplate, RELEASE_ID_LATEST, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID);
        this.checkKieContainerResource(RELEASE_ID_LATEST, RELEASE_ID);
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar101");
        this.controllerClient.scanNow((ContainerSpecKey)container);
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID_101);
        this.checkKieContainerResource(RELEASE_ID_101, RELEASE_ID_101);
    }

    @Test
    public void testScanNowNotExistingContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = new ContainerSpec("not-existing", "not-existing", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, null);
        try {
            this.controllerClient.scanNow((ContainerSpecKey)container);
            Assert.fail((String)"Should throw exception about container not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)"No container spec found for id not-existing");
        }
    }

    @Test
    @Category(value={UnstableOnJenkinsPrBuilder.class})
    public void testStartAndStopScanner() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = this.createContainerSpec(serverTemplate, RELEASE_ID_LATEST, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID);
        this.checkKieContainerResource(RELEASE_ID_LATEST, RELEASE_ID);
        this.controllerClient.startScanner((ContainerSpecKey)container, Long.valueOf(5000L));
        KieServerSynchronization.waitForContainerWithScannerStatus((KieServicesClient)this.client, (KieScannerStatus)KieScannerStatus.STARTED);
        RuleConfig containerConfig = (RuleConfig)this.controllerClient.getContainerInfo(serverTemplate.getId(), "kie-concurrent").getConfigs().get(Capability.RULE);
        Assertions.assertThat((Comparable)containerConfig.getScannerStatus()).isEqualTo((Object)KieScannerStatus.STARTED);
        Assertions.assertThat((Long)containerConfig.getPollInterval()).isEqualTo(5000L);
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar101");
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID_101);
        this.checkKieContainerResource(RELEASE_ID_101, RELEASE_ID_101);
        this.controllerClient.stopScanner((ContainerSpecKey)container);
        containerConfig = (RuleConfig)this.controllerClient.getContainerInfo(serverTemplate.getId(), "kie-concurrent").getConfigs().get(Capability.RULE);
        Assertions.assertThat((Comparable)containerConfig.getScannerStatus()).isEqualTo((Object)KieScannerStatus.STOPPED);
        KieServerSynchronization.waitForContainerWithScannerStatus((KieServicesClient)this.client, (KieScannerStatus)KieScannerStatus.STOPPED);
    }

    @Test
    public void testStartScannerNotExistingContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = new ContainerSpec("not-existing", "not-existing", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, null);
        try {
            this.controllerClient.startScanner((ContainerSpecKey)container, Long.valueOf(1000L));
            Assert.fail((String)"Should throw exception about container not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)"No container spec found for id not-existing");
        }
    }

    @Test
    public void testStopScannerNotExistingContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = new ContainerSpec("not-existing", "not-existing", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, null);
        try {
            this.controllerClient.stopScanner((ContainerSpecKey)container);
            Assert.fail((String)"Should throw exception about container not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)"No container spec found for id not-existing");
        }
    }

    @Test
    public void testStopNotRunningScanner() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = this.startContainerWithVersion(RELEASE_ID, serverTemplate);
        this.checkKieContainerResource(RELEASE_ID, RELEASE_ID);
        this.controllerClient.stopContainer((ContainerSpecKey)container);
        this.controllerClient.stopScanner((ContainerSpecKey)container);
    }

    @Test
    public void testUpgradeNotExistingContainer() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec container = new ContainerSpec("not-existing", "not-existing", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, null);
        try {
            this.controllerClient.upgradeContainer((ContainerSpecKey)container, RELEASE_ID_101);
            Assert.fail((String)"Should throw exception about container not found.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)"No container spec found for id not-existing");
        }
    }

    private ContainerSpec startContainerWithVersion(ReleaseId releaseId, ServerTemplate serverTemplate) throws Exception {
        ContainerSpec container = this.createContainerSpec(serverTemplate, releaseId, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)releaseId);
        return container;
    }

    protected ServerTemplate createServerTemplate() {
        return this.createServerTemplate(this.kieServerInfo.getServerId(), this.kieServerInfo.getName(), this.kieServerInfo.getLocation());
    }

    protected void checkKieContainerResource(ReleaseId expectedReleaseId, ReleaseId expectedResolvedReleaseId) {
        ServiceResponse containerInfo = this.client.getContainerInfo("kie-concurrent");
        Assertions.assertThat((Comparable)containerInfo.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        KieContainerResource container = (KieContainerResource)containerInfo.getResult();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(container.getContainerId()).isEqualTo("kie-concurrent");
            softly.assertThat((Comparable)container.getStatus()).isEqualTo((Object)KieContainerStatus.STARTED);
            softly.assertThat((Comparable)container.getReleaseId()).isEqualTo((Object)expectedReleaseId);
            softly.assertThat((Comparable)container.getResolvedReleaseId()).isEqualTo((Object)expectedResolvedReleaseId);
        });
    }
}

