/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.HashMap;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerSynchronization;

public class ContainerConfigPropagationIntegrationTest
extends KieControllerManagementBaseTest {
    private KieServerInfo kieServerInfo;

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar");
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar101");
    }

    @Before
    public void getKieServerInfo() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
        ServiceResponse reply = this.client.getServerInfo();
        Assume.assumeThat((Object)reply.getType(), (Matcher)Is.is((Object)KieServiceResponse.ResponseType.SUCCESS));
        this.kieServerInfo = (KieServerInfo)reply.getResult();
    }

    @Test
    public void testPropagateProcessContainerConfig() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        HashMap<Capability, ProcessConfig> containerConfigMap = new HashMap<Capability, ProcessConfig>();
        ProcessConfig processConfig = new ProcessConfig("PER_PROCESS_INSTANCE", "kieBase", "kieSession", "MERGE_COLLECTION");
        containerConfigMap.put(Capability.PROCESS, processConfig);
        ContainerSpec containerToDeploy = new ContainerSpec("kie-concurrent", "containerName", (ServerTemplateKey)serverTemplate, RELEASE_ID, KieContainerStatus.STARTED, containerConfigMap);
        this.controllerClient.saveContainerSpec(serverTemplate.getId(), containerToDeploy);
        KieServerSynchronization.waitForKieServerSynchronization((KieServicesClient)this.client, (int)1);
        ServiceResponse containerInfo = this.client.getContainerInfo("kie-concurrent");
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)"kie-concurrent", (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((long)4L, (long)((KieContainerResource)containerInfo.getResult()).getConfigItems().size());
        Assert.assertTrue((boolean)this.containsConfigItem((KieContainerResource)containerInfo.getResult(), "RuntimeStrategy", "PER_PROCESS_INSTANCE", "BPM"));
        Assert.assertTrue((boolean)this.containsConfigItem((KieContainerResource)containerInfo.getResult(), "KBase", "kieBase", "BPM"));
        Assert.assertTrue((boolean)this.containsConfigItem((KieContainerResource)containerInfo.getResult(), "KSession", "kieSession", "BPM"));
        Assert.assertTrue((boolean)this.containsConfigItem((KieContainerResource)containerInfo.getResult(), "MergeMode", "MERGE_COLLECTION", "BPM"));
    }

    private ServerTemplate createServerTemplate() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setId(this.kieServerInfo.getServerId());
        serverTemplate.setName(this.kieServerInfo.getName());
        serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)this.kieServerInfo.getLocation()));
        this.controllerClient.saveServerTemplate(serverTemplate);
        return serverTemplate;
    }

    private boolean containsConfigItem(KieContainerResource containerResource, String itemName, String itemValue, String itemType) {
        Predicate<KieServerConfigItem> matchItem = n -> n.getName().equals(itemName) && n.getValue().equals(itemValue) && n.getType().equals(itemType);
        return containerResource.getConfigItems().stream().anyMatch(matchItem);
    }

    private void assertContainerInfoWithScanner(ReleaseId releaseId, Long pollInterval) {
        ServiceResponse containerInfo = this.client.getContainerInfo("kie-concurrent");
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containerInfo.getType());
        Assert.assertEquals((Object)"kie-concurrent", (Object)((KieContainerResource)containerInfo.getResult()).getContainerId());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getStatus());
        Assert.assertEquals((Object)releaseId, (Object)((KieContainerResource)containerInfo.getResult()).getResolvedReleaseId());
        Assert.assertEquals((Object)pollInterval, (Object)((KieContainerResource)containerInfo.getResult()).getScanner().getPollInterval());
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)((KieContainerResource)containerInfo.getResult()).getScanner().getStatus());
    }
}

