/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.integrationtests.category.UnstableOnJenkinsPrBuilder;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.common.Assert;

public class KieControllerValidationIntegrationTest
extends KieControllerManagementBaseTest {
    protected static Logger logger = LoggerFactory.getLogger(KieControllerValidationIntegrationTest.class);
    private KieServerStateRepository dummyKieServerStateRepository;
    private KieServerRegistry registry = new KieServerRegistryImpl();

    @Before
    public void init() {
        this.dummyKieServerStateRepository = new KieServerStateRepository(){

            public void store(String serverId, KieServerState kieServerState) {
            }

            public KieServerState load(String serverId) {
                KieServerState kieServerState = new KieServerState();
                kieServerState.setControllers(Collections.singleton(TestConfig.getControllerHttpUrl()));
                kieServerState.setConfiguration(new KieServerConfig());
                if (TestConfig.isLocalServer()) {
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.user", "", null));
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.pwd", "", null));
                } else {
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.user", TestConfig.getUsername(), null));
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.pwd", TestConfig.getPassword(), null));
                }
                return kieServerState;
            }
        };
        this.registry = new KieServerRegistryImpl();
        this.registry.registerStateRepository(this.dummyKieServerStateRepository);
    }

    @Test
    @Category(value={UnstableOnJenkinsPrBuilder.class})
    public void testBadRegistered() throws Exception {
        String SERVER_TEMPLATE_ID = "test.mode.bad";
        String SERVER_NAME = "server-name";
        KieServerEnvironment.setServerId((String)"test.mode.bad");
        ServerTemplate serverTemplate = KieControllerValidationIntegrationTest.buildServerTemplate("test.mode.bad", "server-name", null, KieServerMode.DEVELOPMENT, Collections.singletonList(Capability.PROCESS.name()));
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        org.junit.Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        KieServerInfo kieServerInfo = new KieServerInfo("test.mode.bad", "1.0.0");
        kieServerInfo.setLocation("http://127.0.0.1:20000");
        kieServerInfo.setMode(KieServerMode.PRODUCTION);
        kieServerInfo.setName("server-name");
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl(this.registry);
        Assertions.assertThatThrownBy(() -> KieControllerValidationIntegrationTest.lambda$testBadRegistered$0((KieServerController)controller, kieServerInfo)).isInstanceOf(KieControllerNotConnectedException.class);
        ServerInstanceKeyList list = this.controllerClient.getServerInstances("test.mode.bad");
        logger.info("list {}", (Object[])list.getServerInstanceKeys());
        org.junit.Assert.assertTrue((list.getServerInstanceKeys() == null || list.getServerInstanceKeys().length == 0 ? 1 : 0) != 0);
        controller.disconnect(kieServerInfo);
        this.controllerClient.deleteServerTemplate("test.mode.bad");
    }

    @Test
    @Category(value={UnstableOnJenkinsPrBuilder.class})
    public void testGoodRegistered() throws Exception {
        String SERVER_TEMPLATE_ID = "test.mode.ok";
        String SERVER_NAME = "server-name";
        KieServerEnvironment.setServerId((String)"test.mode.ok");
        ServerTemplate serverTemplate = KieControllerValidationIntegrationTest.buildServerTemplate("test.mode.ok", "server-name", null, KieServerMode.DEVELOPMENT, Collections.singletonList(Capability.PROCESS.name()));
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        org.junit.Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        KieServerInfo kieServerInfo = new KieServerInfo("test.mode.ok", "1.0.0");
        kieServerInfo.setLocation("http://127.0.0.1:20000");
        kieServerInfo.setMode(KieServerMode.DEVELOPMENT);
        kieServerInfo.setCapabilities(Collections.singletonList("BPM"));
        kieServerInfo.setName("server-name");
        KieServerRegistryImpl registry = new KieServerRegistryImpl();
        registry.registerStateRepository(this.dummyKieServerStateRepository);
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl((KieServerRegistry)registry);
        KieServerSetup setup = controller.connect(kieServerInfo);
        Assert.assertTrue((boolean)setup.hasNoErrors());
        ServerInstanceKeyList list = this.controllerClient.getServerInstances("test.mode.ok");
        if (list == null || list.getServerInstanceKeys() == null || list.getServerInstanceKeys().length == 0) {
            setup = controller.connect(kieServerInfo);
            Assert.assertTrue((boolean)setup.hasNoErrors());
            list = this.controllerClient.getServerInstances("test.mode.ok");
        }
        org.junit.Assert.assertNotNull((Object)list.getServerInstanceKeys());
        org.junit.Assert.assertEquals((long)1L, (long)list.getServerInstanceKeys().length);
        controller.disconnect(kieServerInfo);
        this.controllerClient.deleteServerTemplate("test.mode.ok");
    }

    private static /* synthetic */ void lambda$testBadRegistered$0(KieServerController controller, KieServerInfo kieServerInfo) throws Throwable {
        controller.connect(kieServerInfo);
    }
}

