/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.controller.client.exception.KieServerControllerClientException;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerRuleCapabilitiesIntegrationTest;

public class WebSocketKieControllerRuleCapabilitiesIntegrationTest
extends KieControllerRuleCapabilitiesIntegrationTest<KieServerControllerClientException> {
    @Parameterized.Parameters(name="{0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = WebSocketKieControllerRuleCapabilitiesIntegrationTest.createKieServicesRestConfiguration();
        return Arrays.asList(new Object[][]{{MarshallingFormat.JSON, restConfiguration}});
    }

    @Override
    protected void assertNotFoundException(KieServerControllerClientException e) {
        Assertions.assertThat((String)e.getMessage()).isNotNull();
    }

    @Override
    protected void assertBadRequestException(KieServerControllerClientException e) {
        Assertions.assertThat((String)e.getMessage()).isNotNull();
    }

    @Override
    @Before
    public void createControllerClient() {
        this.controllerClient = TestConfig.isLocalServer() ? KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), null, (String)null) : KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }
}

