/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.extension.custom;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.drools.RulesExecutionService;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/instances/{id}/ksession")
public class CustomResource {
    private static final Logger logger = LoggerFactory.getLogger(CustomResource.class);
    private KieCommands commandsFactory = KieServices.Factory.get().getCommands();
    private RulesExecutionService rulesExecutionService;
    private KieServerRegistry registry;

    public CustomResource() {
    }

    public CustomResource(RulesExecutionService rulesExecutionService, KieServerRegistry registry) {
        this.rulesExecutionService = rulesExecutionService;
        this.registry = registry;
    }

    @POST
    @Path(value="/{ksessionId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response insertFireReturn(@Context HttpHeaders headers, @PathParam(value="id") String id, @PathParam(value="ksessionId") String ksessionId, String cmdPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String contentType = RestUtils.getContentType((HttpHeaders)headers);
        MarshallingFormat format = MarshallingFormat.fromType((String)contentType);
        try {
            KieContainerInstanceImpl kci = this.registry.getContainer(id, ContainerLocatorProvider.get().getLocator());
            Marshaller marshaller = kci.getMarshaller(format);
            List listOfFacts = (List)marshaller.unmarshall(cmdPayload, List.class);
            ArrayList<Command> commands = new ArrayList<Command>();
            BatchExecutionCommand executionCommand = this.commandsFactory.newBatchExecution(commands, ksessionId);
            for (Object fact : listOfFacts) {
                commands.add(this.commandsFactory.newInsert(fact, fact.toString()));
            }
            commands.add(this.commandsFactory.newFireAllRules());
            commands.add(this.commandsFactory.newGetObjects());
            ExecutionResults results = this.rulesExecutionService.call((KieContainerInstance)kci, executionCommand);
            String result = marshaller.marshall((Object)results);
            logger.debug("Returning OK response with content '{}'", (Object)result);
            return RestUtils.createResponse((Object)result, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[0]);
        }
        catch (Exception e) {
            String response = "Execution failed with error : " + e.getMessage();
            logger.debug("Returning Failure response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Header[])new Header[0]);
        }
    }
}

