/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.dmn.DMNKieServerBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class DMNInputDataStringIntegrationTest
extends DMNKieServerBaseIntegrationTest {
    private static final org.kie.server.api.model.ReleaseId kjar1 = new org.kie.server.api.model.ReleaseId("org.kie.server.testing", "input-data-string", "1.0.0.Final");
    private static final String CONTAINER_ID = "input-data-string";
    private static final String MODEL_NAMESPACE = "https://github.com/kiegroup/kie-dmn/input-data-string";
    private static final String MODEL_NAME = "input-data-string";

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/input-data-string").getFile());
        kieContainer = KieServices.Factory.get().newKieContainer((ReleaseId)kjar1);
        DMNInputDataStringIntegrationTest.createContainer((String)"input-data-string", (org.kie.server.api.model.ReleaseId)kjar1);
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    @Test
    public void test_evaluateAll() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll("input-data-string", dmnContext);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void testInputStringEvaluateDecisionByName() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", "Greeting Message", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", "nonExistantName", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", "", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        try {
            dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", null, dmnContext).getResult();
            Assert.fail((String)"There is no point in calling evaluateDecisionByName with null parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStringEvaluateDecisionById() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", "d_GreetingMessage", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultById("d_GreetingMessage").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", "nonExistantId", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", "", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        try {
            dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", null, dmnContext).getResult();
            Assert.fail((String)"There is no point in calling evaluateDecisionById with null parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

