/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn;

import java.math.BigDecimal;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.dmn.DMNKieServerBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class DMNIntegrationTest
extends DMNKieServerBaseIntegrationTest {
    private static final org.kie.server.api.model.ReleaseId kjar1 = new org.kie.server.api.model.ReleaseId("org.kie.server.testing", "function-definition", "1.0.0.Final");
    private static final String CONTAINER_1_ID = "function-definition";

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/function-definition").getFile());
        kieContainer = KieServices.Factory.get().newKieContainer((ReleaseId)kjar1);
        DMNIntegrationTest.createContainer((String)CONTAINER_1_ID, (org.kie.server.api.model.ReleaseId)kjar1);
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    @Test
    public void test_evaluateAll() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("a", (Object)10);
        dmnContext.set("b", (Object)5);
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll(CONTAINER_1_ID, dmnContext);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Map mathInCtx = (Map)dmnResult.getContext().get("Math");
        Assert.assertThat((Object)mathInCtx, (Matcher)Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
        Map dr0 = (Map)dmnResult.getDecisionResultByName("Math").getResult();
        Assert.assertThat((Object)dr0, (Matcher)Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
    }

    @Test
    public void test_evaluateAll2() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("a", (Object)10);
        dmnContext.set("b", (Object)5);
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll(CONTAINER_1_ID, "https://www.drools.org/kie-dmn/function-definition", CONTAINER_1_ID, dmnContext);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Map mathInCtx = (Map)dmnResult.getContext().get("Math");
        Assert.assertThat((Object)mathInCtx, (Matcher)Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
        Map dr0 = (Map)dmnResult.getDecisionResultByName("Math").getResult();
        Assert.assertThat((Object)dr0, (Matcher)Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
    }
}

