/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNModelInfoList;
import org.kie.server.client.impl.DMNServicesClientImpl;
import org.kie.server.integrationtests.dmn.DMNKieServerBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class DMNInputDataStringIntegrationTest
extends DMNKieServerBaseIntegrationTest {
    private static final ReleaseId kjar1 = new ReleaseId("org.kie.server.testing", "input-data-string", "1.0.0.Final");
    private static final ReleaseId kjar_v101 = new ReleaseId("org.kie.server.testing", "input-data-string", "1.0.1.Final");
    private static final String CONTAINER_ID = "input-data-string";
    private static final String MODEL_NAMESPACE = "https://github.com/kiegroup/kie-dmn/input-data-string";
    private static final String MODEL_NAME = "input-data-string";

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/input-data-string").getFile());
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/input-data-string-101").getFile());
    }

    @Before
    public void cleanContainers() {
        DMNInputDataStringIntegrationTest.disposeAllContainers();
        DMNInputDataStringIntegrationTest.createContainer((String)"input-data-string", (ReleaseId)kjar1);
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    @Test
    public void test_evaluateAll() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll("input-data-string", dmnContext);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void test_evaluateAll_withUpdate() {
        ServiceResponse models = this.dmnClient.getModels("input-data-string");
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)models.getType());
        Assert.assertEquals((long)1L, (long)((DMNModelInfoList)models.getResult()).getModels().size());
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll("input-data-string", dmnContext);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
        KieServerAssert.assertSuccess((ServiceResponse)this.client.updateReleaseId("input-data-string", kjar_v101));
        models = this.dmnClient.getModels("input-data-string");
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)models.getType());
        Assert.assertEquals((long)1L, (long)((DMNModelInfoList)models.getResult()).getModels().size());
        evaluateAll = this.dmnClient.evaluateAll("input-data-string", dmnContext);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        dmnResult = (DMNResult)evaluateAll.getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Salve John Doe"));
    }

    @Test
    public void testInputStringEvaluateDecisionByName() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", "Greeting Message", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", "nonExistantName", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", "", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        try {
            dmnResult = (DMNResult)this.dmnClient.evaluateDecisionByName("input-data-string", MODEL_NAMESPACE, "input-data-string", null, dmnContext).getResult();
            Assert.fail((String)"There is no point in calling evaluateDecisionByName with null parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStringEvaluateDecisionById() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", "d_GreetingMessage", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultById("d_GreetingMessage").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", "nonExistantId", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", "", dmnContext).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)Matchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        try {
            dmnResult = (DMNResult)this.dmnClient.evaluateDecisionById("input-data-string", MODEL_NAMESPACE, "input-data-string", null, dmnContext).getResult();
            Assert.fail((String)"There is no point in calling evaluateDecisionById with null parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testDROOLS2234() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNServicesClientImpl testClient = (DMNServicesClientImpl)this.dmnClient;
        DMNContextKS custom_payload = new DMNContextKS(MODEL_NAMESPACE, "input-data-string", dmnContext.getAll());
        custom_payload.setDecisionIds(null);
        custom_payload.setDecisionNames(null);
        DMNResult dmnResult = (DMNResult)testClient.evaluateDecisions("input-data-string", custom_payload).getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultById("d_GreetingMessage").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
    }
}

