/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNDecisionInfo;
import org.kie.server.api.model.dmn.DMNModelInfo;
import org.kie.server.api.model.dmn.DMNModelInfoList;
import org.kie.server.integrationtests.dmn.DMNKieServerBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class DMNTwoDMNModelsIntegrationTest
extends DMNKieServerBaseIntegrationTest {
    private static final ReleaseId kjar1 = new ReleaseId("org.kie.server.testing", "two-dmn-models", "1.0.0.Final");
    private static final String CONTAINER_1_ID = "two-dmn-models";

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/two-dmn-models").getFile());
        kieContainer = KieServices.Factory.get().newKieContainer((org.kie.api.builder.ReleaseId)kjar1);
        DMNTwoDMNModelsIntegrationTest.createContainer((String)CONTAINER_1_ID, (ReleaseId)kjar1);
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    @Test
    public void test_getModels() {
        ServiceResponse getModels = this.dmnClient.getModels(CONTAINER_1_ID);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)getModels.getType());
        List models = ((DMNModelInfoList)getModels.getResult()).getModels();
        Assert.assertThat((Object)models, (Matcher)Matchers.hasSize((int)2));
        DMNModelInfo fdModel = models.stream().filter(mi -> mi.getName().equals("function-definition")).findFirst().orElse(null);
        Assert.assertThat((Object)fdModel, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fdModel.getNamespace(), (Matcher)Matchers.is((Object)"https://www.drools.org/kie-dmn/function-definition"));
        Assert.assertThat((Object)fdModel.getDecisions(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((DMNDecisionInfo)fdModel.getDecisions().iterator().next()).getName(), (Matcher)Matchers.is((Object)"Math"));
        DMNModelInfo idsModel = models.stream().filter(mi -> mi.getName().equals("input-data-string")).findFirst().orElse(null);
        Assert.assertThat((Object)idsModel, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)idsModel.getNamespace(), (Matcher)Matchers.is((Object)"https://github.com/kiegroup/kie-dmn/input-data-string"));
        Assert.assertThat((Object)idsModel.getDecisions(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((DMNDecisionInfo)idsModel.getDecisions().iterator().next()).getName(), (Matcher)Matchers.is((Object)"Greeting Message"));
    }

    @Test
    public void test_evaluateAllOnInputDataStringModel() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll(CONTAINER_1_ID, "https://github.com/kiegroup/kie-dmn/input-data-string", "input-data-string", dmnContext);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void test_evaluateAllOnFunctionDefinitionModel() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("a", (Object)10);
        dmnContext.set("b", (Object)5);
        ServiceResponse evaluateAll = this.dmnClient.evaluateAll(CONTAINER_1_ID, "https://www.drools.org/kie-dmn/function-definition", "function-definition", dmnContext);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)evaluateAll.getType());
        DMNResult dmnResult = (DMNResult)evaluateAll.getResult();
        Map mathInCtx = (Map)dmnResult.getContext().get("Math");
        Assert.assertThat((Object)mathInCtx, (Matcher)Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
        Map dr0 = (Map)dmnResult.getDecisionResultByName("Math").getResult();
        Assert.assertThat((Object)dr0, (Matcher)Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
    }
}

