/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNInputDataInfo;
import org.kie.server.api.model.dmn.DMNItemDefinitionInfo;
import org.kie.server.api.model.dmn.DMNModelInfo;
import org.kie.server.api.model.dmn.DMNModelInfoList;
import org.kie.server.api.model.dmn.DMNQNameInfo;
import org.kie.server.integrationtests.dmn.DMNKieServerBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class DMNGetModelsIntegrationTest
extends DMNKieServerBaseIntegrationTest {
    private static final ReleaseId kjar1 = new ReleaseId("org.kie.server.testing", "get-models", "1.0.0.Final");
    private static final String CONTAINER_1_ID = "get-models";

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/get-models").getFile());
        kieContainer = KieServices.Factory.get().newKieContainer((org.kie.api.builder.ReleaseId)kjar1);
        DMNGetModelsIntegrationTest.createContainer((String)CONTAINER_1_ID, (ReleaseId)kjar1);
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    @Test
    public void test_getModels() {
        ServiceResponse modelInfoListResponse = this.dmnClient.getModels(CONTAINER_1_ID);
        Assert.assertThat((Object)modelInfoListResponse.getType(), (Matcher)Matchers.is((Object)KieServiceResponse.ResponseType.SUCCESS));
        List models = ((DMNModelInfoList)modelInfoListResponse.getResult()).getModels();
        Assert.assertThat((Object)models, (Matcher)Matchers.hasSize((int)1));
        DMNModelInfo modelInfo = (DMNModelInfo)models.get(0);
        Assert.assertThat((Object)modelInfo.getName(), (Matcher)Matchers.is((Object)"a number a string a list of numbers"));
        Collection inputs = modelInfo.getInputs();
        Assert.assertThat((Object)inputs, (Matcher)Matchers.hasSize((int)4));
        this.assertCollectionOfInputDataForNameHasTypeRef(inputs, "a number", "feel", "number");
        this.assertCollectionOfInputDataForNameHasTypeRef(inputs, "a string", "feel", "string");
        this.assertCollectionOfInputDataForNameHasTypeRef(inputs, "a list of numbers", "", "tList");
        this.assertCollectionOfInputDataForNameHasTypeRef(inputs, "a Person", "", "tPerson");
        Collection itemDefs = modelInfo.getItemDefinitions();
        Assert.assertThat((Object)itemDefs, (Matcher)Matchers.hasSize((int)2));
        DMNItemDefinitionInfo tList = itemDefs.stream().filter(id -> id.getName().equals("tList")).findFirst().get();
        Assert.assertThat((Object)tList.getTypeRef().getLocalPart(), (Matcher)Matchers.is((Object)"number"));
        Assert.assertThat((Object)tList.getTypeRef().getPrefix(), (Matcher)Matchers.is((Object)"feel"));
        Assert.assertThat((Object)tList.getIsCollection(), (Matcher)Matchers.is((Object)true));
        DMNItemDefinitionInfo tPerson = itemDefs.stream().filter(id -> id.getName().equals("tPerson")).findFirst().get();
        Assert.assertThat((Object)tPerson.getTypeRef(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)tPerson.getIsCollection(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)tPerson.getItemComponent(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(0)).getName(), (Matcher)Matchers.is((Object)"full name"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(0)).getTypeRef().getLocalPart(), (Matcher)Matchers.is((Object)"string"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(0)).getTypeRef().getPrefix(), (Matcher)Matchers.is((Object)"feel"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(1)).getName(), (Matcher)Matchers.is((Object)"age"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(1)).getTypeRef().getLocalPart(), (Matcher)Matchers.is((Object)"number"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(1)).getTypeRef().getPrefix(), (Matcher)Matchers.is((Object)"feel"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(2)).getName(), (Matcher)Matchers.is((Object)"favorite numbers"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(2)).getTypeRef().getLocalPart(), (Matcher)Matchers.is((Object)"tList"));
        Assert.assertThat((Object)((DMNItemDefinitionInfo)tPerson.getItemComponent().get(2)).getTypeRef().getPrefix(), (Matcher)Matchers.is((Object)""));
    }

    private void assertCollectionOfInputDataForNameHasTypeRef(Collection<DMNInputDataInfo> inputs, String name, String typeRefPrefix, String typeRefLocalPart) {
        DMNInputDataInfo idANumber = inputs.stream().filter(id -> id.getName().equals(name)).findFirst().get();
        DMNQNameInfo typeRef = idANumber.getTypeRef();
        Assert.assertThat((Object)typeRef.getLocalPart(), (Matcher)Matchers.is((Object)typeRefLocalPart));
        Assert.assertThat((Object)typeRef.getPrefix(), (Matcher)Matchers.is((Object)typeRefPrefix));
    }
}

