/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.gateway;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerGateway {
    public static final Logger LOG = LoggerFactory.getLogger(KieServerGateway.class);
    private final KieServicesConfiguration config;
    private KieServicesClient client;

    public KieServerGateway(String protocol, String hostname, Integer port, String username, String password, Integer timeout, String contextPath) {
        String serverUrl = protocol + "://" + hostname + ":" + port + "/" + contextPath + "/services/rest/server";
        LOG.info("Server Url {}", (Object)serverUrl);
        this.config = KieServicesFactory.newRestConfiguration((String)serverUrl, (String)username, (String)password);
        this.config.setMarshallingFormat(MarshallingFormat.JSON);
        this.config.setTimeout((long)timeout.intValue());
    }

    public void init() throws MojoFailureException {
        try {
            this.client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        }
        catch (RuntimeException kieEx) {
            throw new MojoFailureException("error on establish connection with remote server: " + kieEx.getMessage(), kieEx.getCause());
        }
    }

    public void deploy(MavenProject project, String container, RuntimeStrategy strategy) throws MojoFailureException {
        KieContainerResource kieContainer = new KieContainerResource();
        kieContainer.setContainerId(container);
        ReleaseId releaseId = new ReleaseId();
        releaseId.setGroupId(project.getGroupId());
        releaseId.setArtifactId(project.getArtifactId());
        releaseId.setVersion(project.getVersion());
        kieContainer.setReleaseId(releaseId);
        if (strategy != null) {
            KieServerConfigItem configItem = new KieServerConfigItem();
            configItem.setName("RuntimeStrategy");
            configItem.setValue(strategy.name());
            configItem.setType("BPM");
            kieContainer.addConfigItem(configItem);
        }
        ServiceResponse serviceResponse = this.client.createContainer(container, kieContainer);
        ServiceResponse.ResponseType type = serviceResponse.getType();
        String msg = serviceResponse.getMsg();
        LOG.info("Deploy Response: {}", (Object)serviceResponse);
        if (ServiceResponse.ResponseType.FAILURE.equals((Object)type)) {
            throw new MojoFailureException(msg);
        }
    }

    public void dispose(String container) throws MojoFailureException {
        ServiceResponse serviceResponse = this.client.disposeContainer(container);
        ServiceResponse.ResponseType type = serviceResponse.getType();
        String msg = serviceResponse.getMsg();
        LOG.info("Dispose Response: {}", (Object)serviceResponse);
        if (ServiceResponse.ResponseType.FAILURE.equals((Object)type)) {
            throw new MojoFailureException(msg);
        }
    }

    public void update(MavenProject project, String container) throws MojoFailureException {
        ReleaseId releaseId = new ReleaseId();
        releaseId.setGroupId(project.getGroupId());
        releaseId.setArtifactId(project.getArtifactId());
        releaseId.setVersion(project.getVersion());
        ServiceResponse serviceResponse = this.client.updateReleaseId(container, releaseId);
        ServiceResponse.ResponseType type = serviceResponse.getType();
        String msg = serviceResponse.getMsg();
        LOG.info("Replace Response: {}", (Object)serviceResponse);
        if (ServiceResponse.ResponseType.FAILURE.equals((Object)type)) {
            throw new MojoFailureException(msg);
        }
    }
}

