/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.maven.plugin;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.server.gateway.KieServerGateway;

public abstract class KieServerAbstactMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=false, readonly=true)
    protected MavenProject project;
    @Parameter(property="deploy.container")
    protected String container;
    @Parameter(property="deploy.hostname", defaultValue="localhost")
    protected String hostname;
    @Parameter(property="deploy.port", defaultValue="8080")
    protected Integer port;
    @Parameter(property="deploy.protocol", defaultValue="http")
    protected String protocol;
    @Parameter(property="deploy.context-path", defaultValue="kie-server")
    protected String contextPath;
    @Parameter(property="deploy.username", required=true, readonly=true)
    protected String username;
    @Parameter(property="deploy.password", required=true, readonly=true)
    protected String password;
    @Parameter(property="deploy.timeout", defaultValue="30000")
    protected Integer timeout;
    protected KieServerGateway kieServerGateway;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)this.project.toString());
        this.getLog().info((CharSequence)("Protocol: " + this.protocol));
        this.getLog().info((CharSequence)("Host Name: " + this.hostname));
        this.getLog().info((CharSequence)("Port: " + this.port));
        this.getLog().info((CharSequence)("Username: " + this.username));
        this.getLog().info((CharSequence)"Password: ###SECRET###");
        this.getLog().info((CharSequence)("Timeout: " + this.timeout));
        this.getLog().info((CharSequence)("Context Path: " + this.contextPath));
        if (this.container == null) {
            this.container = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion();
        }
        this.kieServerGateway = new KieServerGateway(this.protocol, this.hostname, this.port, this.username, this.password, this.timeout, this.contextPath);
        this.kieServerGateway.init();
        this.excecuteCommand();
    }

    public abstract void excecuteCommand() throws MojoExecutionException, MojoFailureException;
}

