/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.server.maven.plugin.KieServerAbstactMojo;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=true)
public class DeployMojo
extends KieServerAbstactMojo {
    @Parameter(property="deploy.runtime-strategy", readonly=true)
    private String runtimeStrategy;

    @Override
    public void excecuteCommand() throws MojoExecutionException, MojoFailureException {
        RuntimeStrategy strategy;
        if (this.runtimeStrategy == null) {
            this.getLog().info((CharSequence)"Using deployment descriptor runtime strategy");
            this.kieServerGateway.deploy(this.project, this.container, null);
            return;
        }
        try {
            strategy = RuntimeStrategy.valueOf((String)this.runtimeStrategy);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoFailureException("Runtime Strategy Not Found: " + this.runtimeStrategy);
        }
        this.getLog().info((CharSequence)("Override Runtime Strategy: " + this.runtimeStrategy));
        this.kieServerGateway.deploy(this.project, this.container, strategy);
    }
}

