/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URLDecoder;
import java.text.MessageFormat;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.ui.ImageServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Process images")
@Path(value="server/containers/{containerId}/images")
public class ImageResource {
    private static final Logger logger = LoggerFactory.getLogger(ImageResource.class);
    private ImageServiceBase imageServiceBase;
    private KieServerRegistry context;

    public ImageResource() {
    }

    public ImageResource(ImageServiceBase imageServiceBase, KieServerRegistry context) {
        this.imageServiceBase = imageServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Returns an SVG image file of a specified process definition diagram.", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process definition, image or Container Id not found")})
    @GET
    @Path(value="processes/{processId}")
    @Produces(value={"application/svg+xml"})
    public Response getProcessImage(@Context HttpHeaders headers, @ApiParam(value="container id that process definition belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process definition that image should be loaded for", required=true, example="evaluation") @PathParam(value="processId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String svgString = this.imageServiceBase.getProcessImage(containerId, processId);
            logger.debug("Returning OK response with content '{}'", (Object)svgString);
            return RestUtils.createResponse((Object)svgString, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)("Image for process id " + processId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns an annotated SVG image file of a specified process instance diagram.", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, image or Container Id not found")})
    @GET
    @Path(value="processes/instances/{processInstanceId}")
    @Produces(value={"application/svg+xml"})
    public Response getProcessInstanceImage(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that image should be loaded for", required=true, example="123") @PathParam(value="processInstanceId") Long procInstId, @ApiParam(value="svg completed node color", required=false, example="#C0C0C0") @QueryParam(value="svgCompletedColor") @DefaultValue(value="#C0C0C0") String svgNodeCompletedColor, @ApiParam(value="svg completed node border color", required=false, example="#030303") @QueryParam(value="svgCompletedBorderColor") @DefaultValue(value="#030303") String svgNodeCompletedBorderColor, @ApiParam(value="svg active node border color", required=false, example="#1e90ff") @QueryParam(value="svgActiveBorderColor") @DefaultValue(value="#1e90ff") String svgActiveNodeBorderColor, @ApiParam(value="show or hidden instance badges", required=false, example="false") @QueryParam(value="svgInstanceBadgesShow") @DefaultValue(value="false") boolean showBadges, @ApiParam(value="svg active async node border color", required=false, example="#FF0000") @QueryParam(value="svgActiveAsyncBorderColor") @DefaultValue(value="#FF0000") String svgActiveAsyncNodeBorderColor) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String svgString = this.imageServiceBase.getActiveProcessImage(containerId, procInstId.longValue(), "#C0C0C0".equals(svgNodeCompletedColor) ? "#C0C0C0" : URLDecoder.decode(svgNodeCompletedColor, "UTF-8"), "#030303".equals(svgNodeCompletedBorderColor) ? "#030303" : URLDecoder.decode(svgNodeCompletedBorderColor, "UTF-8"), "#1e90ff".equals(svgActiveNodeBorderColor) ? "#1e90ff" : URLDecoder.decode(svgActiveNodeBorderColor, "UTF-8"), Boolean.valueOf(showBadges), "#FF0000".equals(svgActiveAsyncNodeBorderColor) ? "#FF0000" : URLDecoder.decode(svgActiveAsyncNodeBorderColor, "UTF-8"));
            logger.debug("Returning OK response with content '{}'", (Object)svgString);
            return RestUtils.createResponse((Object)svgString, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Not found", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)("Image for process instance id " + procInstId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

